/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class InvisCommand
implements Command {
    int accessLevel = 200;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer player = CampaignMain.cm.getPlayer(Username);
        if (player == null) {
            return;
        }
        if (player.getDutyStatus() != 2) {
            CampaignMain.cm.toUser("AM:You must be in reserve to change visibility.", Username, true);
            return;
        }
        player.setInvisible(!player.isInvisible());
        CampaignMain.cm.getServer().sendRemoveUserToAll(Username, false);
        CampaignMain.cm.getServer().getUser(Username).setInvis(player.isInvisible());
        CampaignMain.cm.getServer().sendNewUserToAll(Username, false);
        CampaignMain.cm.sendPlayerStatusUpdate(player, true);
        CampaignMain.cm.toUser("AM:You have become " + (player.isInvisible() ? "invisible" : "visible"), Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has become " + (player.isInvisible() ? "invisible" : "visible"));
    }
}

