/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.Unit;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.commands.Command;

public class RemoveFactionPilotCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Faction Name#Type[Mek,Vehicle,Infantry,Proto,BattleArmor,Aero]/ALL#Position[Not used if ALL is selected]";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String house = "";
        String type = "";
        String weight = "";
        String position = "";
        try {
            house = command.nextToken();
            type = command.nextToken();
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser(this.syntax, Username);
            return;
        }
        SHouse h = CampaignMain.cm.getHouseFromPartialString(house, Username);
        try {
            if (type.equalsIgnoreCase("all")) {
                if (weight.equalsIgnoreCase("all")) {
                    if (CampaignMain.cm.isUsingMySQL()) {
                        CampaignMain.cm.MySQL.deleteFactionPilots(h.getDBId());
                    }
                    h.getPilotQueues().flushQueue();
                }
            } else {
                position = command.nextToken();
                if (position.equalsIgnoreCase("all")) {
                    h.getPilotQueues().getPilotQueue(Unit.getTypeIDForName(type)).clear();
                    if (CampaignMain.cm.isUsingMySQL()) {
                        CampaignMain.cm.MySQL.deleteFactionPilots(h.getDBId(), Unit.getTypeIDForName(type));
                    }
                } else if (position.indexOf("-") > 0) {
                    int start;
                    int end = Integer.parseInt(position.substring(0, position.indexOf("-")));
                    for (int pos = start = Integer.parseInt(position.substring(position.indexOf("-") + 1)); pos >= end; --pos) {
                        if (CampaignMain.cm.isUsingMySQL()) {
                            CampaignMain.cm.MySQL.deletePilot(h.getPilotQueues().getPilotQueue(Unit.getTypeIDForName(type)).get(pos).getPilotId());
                        }
                        h.getPilotQueues().getPilotQueue(Unit.getTypeIDForName(type)).remove(pos);
                    }
                } else {
                    h.getPilotQueues().getPilotQueue(Unit.getTypeIDForName(type)).remove(Integer.parseInt(position));
                    if (CampaignMain.cm.isUsingMySQL()) {
                        CampaignMain.cm.MySQL.deletePilot(h.getPilotQueues().getPilotQueue(Unit.getTypeIDForName(type)).get(Integer.parseInt(position)).getPilotId());
                    }
                }
            }
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser(this.syntax, Username);
            return;
        }
        h.updated();
        CampaignMain.cm.doSendModMail("NOTE", Username + " has removed pilots from " + h.getName() + "'s pilot queue");
    }
}

