/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;

public class RemoveSongCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Song Name";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        File songList = new File("./data/songs.txt");
        if (!songList.exists()) {
            return;
        }
        String songName = command.nextToken();
        StringBuilder songBuffer = new StringBuilder();
        try {
            FileInputStream fis = new FileInputStream(songList);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            while (dis.ready()) {
                String song = dis.readLine();
                if (song.toLowerCase().startsWith(songName.toLowerCase()) || song.trim().length() <= 0) continue;
                songBuffer.append(song + "\n");
            }
            fis.close();
            dis.close();
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("Unable to remove song!", Username, true);
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(songList);
            PrintStream ps = new PrintStream(fos);
            ps.print(songBuffer.toString());
            ps.close();
            fos.close();
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("Unable to create new songs.txt", Username, true);
            return;
        }
        CampaignMain.cm.doSendModMail("NOTE", Username + " has removed " + songName + " from the song list!");
    }
}

