/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;

public class RetrieveAllOperationsCommand
implements Command {
    int accessLevel = 200;
    String syntax = "optype[Short/Long/Speical]";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        String opType;
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        try {
            opType = command.nextToken();
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("Syntax retrievealloperations#optype", Username, true);
            return;
        }
        File opFiles = new File("./data/operations/" + opType);
        if (!opFiles.exists()) {
            CampaignMain.cm.toUser("No files found for Op type " + opType, Username, true);
            return;
        }
        StringBuilder opData = new StringBuilder();
        for (File opFile : opFiles.listFiles()) {
            try {
                FileInputStream fis = new FileInputStream(opFile);
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                opData.append(opFile.getName().substring(0, opFile.getName().lastIndexOf(".txt")) + "#");
                while (dis.ready()) {
                    opData.append(dis.readLine().replaceAll("#", "(pound)") + "#");
                }
                dis.close();
                fis.close();
                CampaignMain.cm.doSendModMail("NOTE", Username + " has retrieved " + opFile.getName());
                CampaignMain.cm.toUser("PL|RSOD|" + opData.toString(), Username, false);
                opData.setLength(0);
            }
            catch (Exception ex) {
                CampaignMain.cm.toUser("Unable to read " + opFile.getName(), Username, true);
                return;
            }
        }
    }
}

