/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;

public class RetrieveOperationCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Op Type[Short/Long/Special]#Op Name";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        String opName;
        String opType;
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        try {
            opType = command.nextToken();
            opName = command.nextToken();
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("Syntax retrieveoperation#optype#opname", Username, true);
            return;
        }
        File opFile = new File("./data/operations/" + opType + "/" + opName + ".txt");
        if (!opFile.exists()) {
            CampaignMain.cm.toUser("No file found for Op " + opName, Username, true);
            return;
        }
        StringBuilder opData = new StringBuilder();
        try {
            FileInputStream fis = new FileInputStream(opFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            opData.append(opName + "#");
            while (dis.ready()) {
                opData.append(dis.readLine().replaceAll("#", "(pound)") + "#");
            }
            dis.close();
            fis.close();
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("Unable to read " + opFile, Username, true);
            return;
        }
        CampaignMain.cm.doSendModMail("NOTE", Username + " has retrieved " + opFile);
        CampaignMain.cm.toUser("PL|RSOD|" + opData.toString(), Username, false);
    }
}

