/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.AdvancedTerrain;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class SetAdvancedPlanetTerrainCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Planet Name$Terrain ID$Display Name$XSize$YSize$StaticMap(bool)$Xboard$YBoard$Low Temp$High Temp$Gravity(Double)$Vaccum(bool)$Night Chance$Night Temp Mod$Static Map(bool)$Min Visibility$Max Visibility$";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlanet planet = (SPlanet)CampaignMain.cm.getData().getPlanetByName(command.nextToken());
        if (planet == null) {
            CampaignMain.cm.toUser("Unknown Planet", Username, true);
            return;
        }
        int id = Integer.parseInt(command.nextToken());
        AdvancedTerrain aTerrain = planet.getAdvancedTerrain().get(new Integer(id));
        if (aTerrain == null) {
            CampaignMain.cm.toUser("Could not find that terrain on planet " + planet.getName(), Username, true);
            return;
        }
        aTerrain = new AdvancedTerrain(command.nextToken());
        planet.getAdvancedTerrain().put(new Integer(id), aTerrain);
        planet.setAdvancedTerrain(planet.getAdvancedTerrain());
        planet.updated();
        if (CampaignMain.cm.isUsingMySQL()) {
            planet.toDB();
        }
        CampaignMain.cm.toUser("Advanced Terrain set for terrain: " + aTerrain.getDisplayName() + " on planet " + planet.getName(), Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has set Advanced Terrain for terrain: " + aTerrain.getDisplayName() + " on planet " + planet.getName());
    }
}

