/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.commands.Command;

public class SetFactionToFactionRewardPointMultiplierCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Faction Name#Faction Name#Multipler";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SHouse faction1 = null;
        SHouse faction2 = null;
        double multiplier = 0.0;
        try {
            faction1 = CampaignMain.cm.getHouseFromPartialString(command.nextToken(), Username);
            faction2 = CampaignMain.cm.getHouseFromPartialString(command.nextToken(), Username);
            multiplier = Double.parseDouble(command.nextToken());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper command. Try: /c SetFactionToFactionRewardPointMultiplier#" + this.syntax, Username, true);
            return;
        }
        if (faction1 == null || faction2 == null) {
            return;
        }
        String rewardMultiplier = faction1.getName() + "To" + faction2.getName() + "RewardPointMultiplier";
        CampaignMain.cm.getConfig().setProperty(rewardMultiplier, Double.toString(multiplier));
        CampaignMain.cm.toUser("You set the reward point multipler for " + faction1.getName() + " to " + faction2.getName() + " to " + multiplier, Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has set reward point multipler for " + faction1.getName() + " to " + faction2.getName() + " to " + multiplier);
    }
}

