/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.Unit;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.commands.Command;

public class SetHouseBasePilotingSkillsCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Faction Name#[Mek,Vehicle,Infantry,Proto,BattleArmor,Aero]#PilotingSkill$PilotingSkill";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int pilotType;
        SHouse house;
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String skills = "";
        try {
            house = CampaignMain.cm.getHouseFromPartialString(command.nextToken(), Username);
            pilotType = Unit.getTypeIDForName(command.nextToken());
            skills = command.nextToken() + "$";
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser(this.syntax, Username);
            return;
        }
        if (house == null) {
            return;
        }
        if (pilotType >= 6 || pilotType < 0) {
            CampaignMain.cm.toUser(this.syntax, Username);
            return;
        }
        house.getPilotQueues().setBasePilotSkill(skills, pilotType);
        house.updated();
        CampaignMain.cm.toUser("You added a piloting skill for unit " + Unit.getTypeClassDesc(pilotType) + " for house " + house.getName() + " to " + skills, Username);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has added a piloting skill for unit " + Unit.getTypeClassDesc(pilotType) + " for house " + house.getName() + " to " + skills + ".");
    }
}

