/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class SetPlanetCompProductionCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Planet Name#Number Of Components";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String PlanetName = command.nextToken();
        int compProduction = 0;
        SPlanet planet = CampaignMain.cm.getPlanetFromPartialString(PlanetName, Username);
        if (planet == null) {
            CampaignMain.cm.toUser(PlanetName + " not found.", Username, true);
            return;
        }
        try {
            if (command.hasMoreTokens()) {
                compProduction = Integer.parseInt(command.nextToken());
            }
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("Invalid Syntax: SetPlanetCompProduction#PlanetName#NumberOfComponents", Username, true);
            return;
        }
        if (planet.getOwner() != null) {
            planet.getOwner().setComponentProduction(planet.getOwner().getComponentProduction() - planet.getCompProduction());
            planet.getOwner().setComponentProduction(planet.getOwner().getComponentProduction() + compProduction);
        }
        planet.setCompProduction(compProduction);
        CampaignMain.cm.toUser(planet.getName() + " has had its component production set to " + planet.getCompProduction(), Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has set planet " + PlanetName + "'s component production to " + planet.getCompProduction());
        planet.updated();
        if (CampaignMain.cm.isUsingMySQL()) {
            planet.toDB();
        }
    }
}

