/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class SetPlanetConquerPointsCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Planet Name#Amount";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlanet p = null;
        int points = 0;
        try {
            p = CampaignMain.cm.getPlanetFromPartialString(command.nextToken(), Username);
            points = Integer.parseInt(command.nextToken());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper command. Try: /c SetPlanetConquerPoints#planet#amount", Username, true);
            return;
        }
        if (p == null) {
            CampaignMain.cm.toUser("Couldn't find a planet with that name.", Username, true);
            return;
        }
        p.setConquestPoints(points);
        p.updated();
        if (CampaignMain.cm.isUsingMySQL()) {
            p.toDB();
        }
        CampaignMain.cm.toUser("You set " + p.getName() + "'s conquer points to " + points, Username, true);
        CampaignMain.cm.doSendModMail("PLANETARY CHANGE", Username + " has changed " + p.getName() + "'s conquer points to " + points);
    }
}

