/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class SetPlanetWareHouseCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Planet Name#Number Of Warehouses";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String PlanetName = command.nextToken();
        int warehouses = 0;
        SPlanet planet = CampaignMain.cm.getPlanetFromPartialString(PlanetName, Username);
        if (planet == null) {
            CampaignMain.cm.toUser(PlanetName + " not found.", Username, true);
            return;
        }
        try {
            if (command.hasMoreTokens()) {
                warehouses = Integer.parseInt(command.nextToken());
            }
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("Invalid Syntax: SetPlanetWareHouse#PlanetName#NumberOfWareHouses", Username, true);
            return;
        }
        planet.setBaysProvided(warehouses);
        if (planet.getOwner() != null) {
            SHouse house = planet.getOwner();
            house.removePlanet(planet);
            house.addPlanet(planet);
            house.updated();
        }
        CampaignMain.cm.toUser(planet.getName() + " has had its number of warehouses set to " + planet.getBaysProvided(), Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has set planet " + PlanetName + " warehouses to " + planet.getBaysProvided());
        planet.updated();
        if (CampaignMain.cm.isUsingMySQL()) {
            planet.toDB();
        }
    }
}

