/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.CampaignData;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;
import server.util.MWPasswd;

public class ShutdownCommand
implements Command {
    int accessLevel = 200;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        CampaignMain.cm.getMarket().removeAllListings();
        CampaignMain.cm.toFile();
        CampaignMain.cm.forceSavePlayers(Username);
        CampaignMain.cm.saveBannedAmmo();
        if (CampaignMain.cm.isUsingMySQL()) {
            CampaignMain.cm.MySQL.closeMySQL();
        }
        CampaignMain.cm.toUser("AM:You halted the server. Have a nice day.", Username, true);
        CampaignData.mwlog.infoLog(Username + " halted the server. Have a nice day!");
        CampaignMain.cm.addToNewsFeed("Server halted!");
        try {
            MWPasswd.save();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Unable to save passwords before shutdown!");
            CampaignData.mwlog.errLog(ex);
        }
        System.exit(0);
    }
}

