/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.leader;

import common.CampaignData;
import java.util.StringTokenizer;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class FactionLeaderMuteCommand
implements Command {
    int accessLevel = CampaignMain.cm.getIntegerConfig("factionLeaderLevel");
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer leader = CampaignMain.cm.getPlayer(Username);
        SPlayer p = null;
        try {
            p = CampaignMain.cm.getPlayer(command.nextToken());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:Improper command. Try: /c factionleadermute#PlayerName", Username, true);
            return;
        }
        if (p == null) {
            CampaignMain.cm.toUser("AM:Couldn't find a player with that name.", Username, true);
            return;
        }
        if (!leader.getMyHouse().getName().equalsIgnoreCase(p.getMyHouse().getName())) {
            CampaignMain.cm.toUser("AM:You are not in the same faction as " + p.getName() + ". You may not mute them!", Username, true);
            return;
        }
        Vector<String> factionIgnores = CampaignMain.cm.getServer().getFactionLeaderIgnoreList();
        if (factionIgnores.indexOf(p.getName()) == -1) {
            factionIgnores.add(p.getName());
            CampaignMain.cm.doSendModMail("NOTE", Username + " faction muted " + p.getName());
            CampaignMain.cm.getServer().sendChat(Username + " muted " + p.getName() + " (faction mute).");
        } else {
            factionIgnores.remove(p.getName());
            CampaignData.mwlog.modLog(Username + " faction unmuted " + p.getName());
            CampaignMain.cm.doSendModMail("NOTE", Username + " faction unmuted " + p.getName());
            CampaignMain.cm.getServer().sendChat(Username + " unmuted " + p.getName() + " (faction mute).");
        }
    }
}

