/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.leader;

import common.util.ComponentToCritsConverter;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class GetComponentConversionCommand
implements Command {
    int accessLevel = CampaignMain.cm.getIntegerConfig("factionLeaderLevel");
    String syntax = "[house name option Staff only]";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer player = CampaignMain.cm.getPlayer(Username);
        SHouse house = player.getMyHouse();
        if (CampaignMain.cm.getServer().isModerator(Username) && command.hasMoreElements()) {
            house = CampaignMain.cm.getHouseFromPartialString(command.nextToken(), Username);
        }
        StringBuffer results = new StringBuffer("PL|CCC|");
        for (ComponentToCritsConverter converter : house.getComponentConverter().values()) {
            results.append(converter.toString("#"));
        }
        CampaignMain.cm.toUser(results.toString(), Username, false);
    }
}

