/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.leader;

import common.UnitFactory;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import server.campaign.BuildTable;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.SUnitFactory;
import server.campaign.commands.Command;

public class PurchaseFactoryCommand
implements Command {
    int accessLevel = 100;
    String syntax = "Factory Name#Type#Weight#Planet";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer player = CampaignMain.cm.getPlayer(Username);
        double cost = 0.0;
        double flu = 0.0;
        int type = 0;
        int weight = 0;
        String name = "";
        int buildType = 1;
        name = command.nextToken();
        type = Integer.parseInt(command.nextToken());
        weight = Integer.parseInt(command.nextToken());
        SPlanet planet = CampaignMain.cm.getPlanetFromPartialString(command.nextToken(), null);
        SHouse house = player.getMyHouse();
        if (planet == null) {
            CampaignMain.cm.toUser("Unable to find planet.", Username);
            return;
        }
        if (house.isNewbieHouse()) {
            CampaignMain.cm.toUser(CampaignMain.cm.getConfig("NewbieHouseName") + " cannot purchase new factories!", Username);
            return;
        }
        if (type == 4 && house.getTechLevel() < 3) {
            CampaignMain.cm.toUser("Your factions tech level is not high enough to purchase Battle Armor factories", Username);
            return;
        }
        if (type == 3 && house.getTechLevel() < 2) {
            CampaignMain.cm.toUser("Your factions tech level is not high enough to purchase ProtoMek factories", Username);
            return;
        }
        if (!planet.isOwner(house.getId())) {
            CampaignMain.cm.toUser("You do not own " + planet.getName(), Username);
            return;
        }
        String buildTable = BuildTable.getFileName("Common", SUnit.getWeightClassDesc(weight), "standard", type);
        if (!new File(buildTable).exists()) {
            CampaignMain.cm.toUser("Sorry but That type of factory cannot be built.", Username);
            return;
        }
        switch (type) {
            case 0: {
                buildType = 1;
                break;
            }
            case 2: {
                buildType = 4;
                break;
            }
            case 1: {
                buildType = 2;
                break;
            }
            case 4: {
                buildType = 16;
                break;
            }
            case 3: {
                buildType = 8;
            }
        }
        cost = CampaignMain.cm.getDoubleConfig("NewFactoryBaseCost");
        cost *= CampaignMain.cm.getDoubleConfig("NewFactoryCostModifier" + SUnit.getWeightClassDesc(weight));
        cost *= CampaignMain.cm.getDoubleConfig("NewFactoryCostModifier" + SUnit.getTypeClassDesc(type));
        cost = Math.round(cost);
        flu = CampaignMain.cm.getDoubleConfig("NewFactoryBaseFlu");
        flu *= CampaignMain.cm.getDoubleConfig("NewFactoryFluModifier" + SUnit.getWeightClassDesc(weight));
        flu *= CampaignMain.cm.getDoubleConfig("NewFactoryFluModifier" + SUnit.getTypeClassDesc(type));
        flu = Math.round(flu);
        if ((double)player.getMoney() < cost) {
            CampaignMain.cm.toUser("AM:You need " + CampaignMain.cm.moneyOrFluMessage(true, true, (int)cost) + " to purchase a factory.", Username);
            return;
        }
        if ((double)player.getInfluence() < flu) {
            CampaignMain.cm.toUser("AM:You need " + CampaignMain.cm.moneyOrFluMessage(false, true, (int)flu) + " to purchase a factory.", Username);
            return;
        }
        cost = Math.max(0.0, cost);
        flu = Math.max(0.0, flu);
        player.addMoney((int)(-cost));
        player.addInfluence((int)(-flu));
        SUnitFactory fac = new SUnitFactory(name, planet, SUnit.getWeightClassDesc(weight), house.getName(), 0, CampaignMain.cm.getIntegerConfig("BaseFactoryRefreshRate"), buildType, "standard", 0);
        Vector<UnitFactory> uf = planet.getUnitFactories();
        uf.add(fac);
        fac.setPlanet(planet);
        planet.setOwner(null, house, true);
        house.updated();
        planet.updated();
        if (CampaignMain.cm.isUsingMySQL()) {
            fac.setID(CampaignMain.cm.MySQL.getFactoryIdByNameAndPlanet(name, planet.getName()));
            fac.toDB();
        }
        CampaignMain.cm.toUser("AM:You have purchased a factory, " + name + ", on planet " + planet.getName() + " for " + CampaignMain.cm.moneyOrFluMessage(true, true, (int)cost) + " and " + CampaignMain.cm.moneyOrFluMessage(false, true, (int)flu), Username, true);
        CampaignMain.cm.doSendHouseMail(house, "NOTE", Username + " has purchased a factory, " + name + ", on planet " + planet.getName() + ".");
    }
}

