/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.leader;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class ResearchTechLevelCommand
implements Command {
    int accessLevel = 100;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer player = CampaignMain.cm.getPlayer(Username);
        SHouse house = player.getMyHouse();
        double cost = 0.0;
        double flu = 0.0;
        if (house.isNewbieHouse()) {
            CampaignMain.cm.toUser("AM:" + CampaignMain.cm.getConfig("NewbieHouseName") + " cannot research technology!", Username);
            return;
        }
        int currentTech = house.getTechResearchLevel();
        if (currentTech >= 6) {
            CampaignMain.cm.toUser("AM:You Faction has researched all known technology!", Username);
            return;
        }
        cost = CampaignMain.cm.getDoubleConfig("TechPointCost");
        if (currentTech > 1) {
            cost *= CampaignMain.cm.getDoubleConfig("TechLevelTechPointCostModifier") * (double)(currentTech - 1);
        }
        cost = Math.round(cost);
        flu = CampaignMain.cm.getDoubleConfig("TechPointFlu");
        if (currentTech > 1) {
            flu *= CampaignMain.cm.getDoubleConfig("TechLevelTechPointFluModifier") * (double)(currentTech - 1);
        }
        flu = Math.round(flu);
        if ((double)player.getMoney() < cost) {
            CampaignMain.cm.toUser("AM:You need " + CampaignMain.cm.moneyOrFluMessage(true, true, (int)cost) + " to research technology.", Username);
            return;
        }
        if ((double)player.getInfluence() < flu) {
            CampaignMain.cm.toUser("AM:You need " + CampaignMain.cm.moneyOrFluMessage(false, true, (int)flu) + " to research technology.", Username);
            return;
        }
        cost = Math.max(0.0, cost);
        flu = Math.max(0.0, flu);
        player.addMoney((int)(-cost));
        player.addInfluence((int)(-flu));
        house.addTechResearchPoint(1);
        if (house.getTechResearchPoints() >= CampaignMain.cm.getIntegerConfig("TechPointsNeedToLevel")) {
            house.updateHouseTechLevel();
            CampaignMain.cm.doSendHouseMail(house, "NOTE", Username + " has increased your factions Tech Level!");
        } else {
            CampaignMain.cm.doSendHouseMail(house, "NOTE", Username + " has taken your faction another step closer to the next technology level!");
        }
        house.updated();
    }
}

