/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.leader;

import common.util.StringUtils;
import java.io.File;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import megamek.common.Entity;
import server.campaign.BuildTable;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;

public class ResearchUnitCommand
implements Command {
    int accessLevel = 100;
    String syntax = "UnitFileName";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer player = CampaignMain.cm.getPlayer(Username);
        SHouse house = player.getMyHouse();
        double cost = 0.0;
        double flu = 0.0;
        String unitFileName = command.nextToken();
        Entity ent = SUnit.loadMech(unitFileName);
        if (house.isNewbieHouse()) {
            CampaignMain.cm.toUser("AM:" + CampaignMain.cm.getConfig("NewbieHouseName") + " cannot research technology!", Username);
            return;
        }
        if (ent.getModel().equals("OMG-UR-FD")) {
            CampaignMain.cm.toUser("AM:Unknown Unit " + unitFileName, Username);
            return;
        }
        int unitTechLevel = house.getTechResearchLevel(ent.getTechLevel());
        if (unitTechLevel > house.getTechResearchLevel()) {
            CampaignMain.cm.toUser("AM:Your faction is unable to research " + StringUtils.aOrAn(ent.getShortNameRaw(), true, true) + " at this time, as your factions technology level is to low!", Username);
            return;
        }
        String buildTableFile = BuildTable.getFileName(house.getName(), SUnit.getWeightClassDesc(SUnit.getEntityWeight(ent)), "standard", SUnit.getEntityType(ent));
        File unitsFile = new File(buildTableFile);
        ConcurrentHashMap<String, Integer> unitList = BuildTable.loadBuildTable(unitsFile);
        if (unitList.containsKey(unitFileName) && unitList.get(unitFileName) >= CampaignMain.cm.getIntegerConfig("MaxUnitResearchPoints")) {
            CampaignMain.cm.toUser("AM:Sorry you've researched this unit as much as possible.", Username);
            return;
        }
        cost = CampaignMain.cm.getDoubleConfig("BaseResearchCost");
        if (unitTechLevel > 1) {
            cost *= CampaignMain.cm.getDoubleConfig("ResearchTechLevelCostModifer") * (double)unitTechLevel;
        }
        cost *= CampaignMain.cm.getDoubleConfig("ResearchCostModifier" + SUnit.getTypeClassDesc(SUnit.getEntityType(ent)));
        cost *= CampaignMain.cm.getDoubleConfig("ResearchCostModifier" + SUnit.getWeightClassDesc(SUnit.getEntityWeight(ent)));
        cost = Math.round(cost);
        flu = CampaignMain.cm.getDoubleConfig("BaseResearchFlu");
        if (unitTechLevel > 1) {
            flu *= CampaignMain.cm.getDoubleConfig("ResearchTechLevelFluModifer") * (double)unitTechLevel;
        }
        flu *= CampaignMain.cm.getDoubleConfig("ResearchFluModifier" + SUnit.getTypeClassDesc(SUnit.getEntityType(ent)));
        flu *= CampaignMain.cm.getDoubleConfig("ResearchFluModifier" + SUnit.getWeightClassDesc(SUnit.getEntityWeight(ent)));
        flu = Math.round(flu);
        if ((double)player.getMoney() < cost) {
            CampaignMain.cm.toUser("AM:You need " + CampaignMain.cm.moneyOrFluMessage(true, true, (int)cost) + " to research " + StringUtils.aOrAn(ent.getShortNameRaw(), true, true) + ".", Username);
            return;
        }
        if ((double)player.getInfluence() < flu) {
            CampaignMain.cm.toUser("AM:You need " + CampaignMain.cm.moneyOrFluMessage(false, true, (int)flu) + " to research " + StringUtils.aOrAn(ent.getShortNameRaw(), true, true) + ".", Username);
            return;
        }
        cost = Math.max(0.0, cost);
        flu = Math.max(0.0, flu);
        player.addMoney((int)(-cost));
        player.addInfluence((int)(-flu));
        if (unitList.containsKey(unitFileName)) {
            unitList.put(unitFileName, unitList.get(unitFileName) + 1);
        } else {
            unitList.put(unitFileName, 1);
        }
        BuildTable.saveBuildTableFile(new File(buildTableFile), unitList);
        buildTableFile = buildTableFile.replaceAll("standard", "reward");
        BuildTable.saveBuildTableFile(new File(buildTableFile), unitList);
        CampaignMain.cm.toUser("AM:You research " + StringUtils.aOrAn(ent.getShortNameRaw(), true, true) + " for " + CampaignMain.cm.moneyOrFluMessage(true, true, (int)cost) + " and " + CampaignMain.cm.moneyOrFluMessage(false, true, (int)flu), Username);
        CampaignMain.cm.doSendHouseMail(house, "NOTE", Username + " has researched " + StringUtils.aOrAn(ent.getShortNameRaw(), true, true) + ".");
    }
}

