/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.leader;

import common.util.ComponentToCritsConverter;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;

public class SetComponentConversionCommand
implements Command {
    int accessLevel = CampaignMain.cm.getIntegerConfig("factionLeaderLevel");
    String syntax = "Crit Name#Weight#Type#Max Production#House[Optional Staff Only]";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer player = CampaignMain.cm.getPlayer(Username);
        SHouse house = player.getMyHouse();
        String crit = command.nextToken();
        int weight = Integer.parseInt(command.nextToken());
        int type = Integer.parseInt(command.nextToken());
        int maxProduction = Integer.parseInt(command.nextToken());
        if (CampaignMain.cm.getServer().isModerator(Username) && command.hasMoreElements()) {
            house = CampaignMain.cm.getHouseFromPartialString(command.nextToken(), Username);
        }
        if (crit.equalsIgnoreCase("all")) {
            house.getComponentConverter().clear();
            ComponentToCritsConverter converter = new ComponentToCritsConverter();
            converter.setComponentUsedType(type);
            converter.setComponentUsedWeight(weight);
            converter.setMinCritLevel(maxProduction);
            house.getComponentConverter().put(converter.getCritName(), converter);
        } else {
            house.getComponentConverter().remove("All");
            ComponentToCritsConverter converter = new ComponentToCritsConverter();
            converter.setCritName(crit);
            converter.setComponentUsedType(type);
            converter.setComponentUsedWeight(weight);
            converter.setMinCritLevel(maxProduction);
            house.getComponentConverter().put(converter.getCritName(), converter);
        }
        CampaignMain.cm.doSendHouseMail(house, "NOTE", player.getName() + " has set components to crit conversion for " + crit + " for " + SUnit.getWeightClassDesc(weight) + "/" + SUnit.getTypeClassDesc(type) + " to a max of " + maxProduction + "  crits.");
    }
}

