/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import java.net.InetAddress;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;

public class BanIPCommand
implements Command {
    int accessLevel = 100;
    String syntax = "Type banip with no arguments for syntax";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        long year;
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        long minute = 60000L;
        long hour = minute * 60L;
        long day = hour * 24L;
        long week = day * 7L;
        long month = day * 30L;
        long howlong = year = day * 365L;
        String timeName = "minutes";
        String toKill = "";
        String banTime = "";
        InetAddress ip = null;
        try {
            toKill = command.nextToken().trim();
            ip = InetAddress.getByName(toKill);
            if (ip.equals(InetAddress.getLocalHost())) {
                CampaignMain.cm.toUser("AM:You may not ban the localhost.", Username);
                return;
            }
            banTime = command.nextToken();
            if (banTime.equalsIgnoreCase("perm")) {
                howlong = 9223372036854775L;
                timeName = "permanently";
            } else {
                String banValue = banTime.substring(banTime.length() - 1);
                timeName = banValue.trim().equalsIgnoreCase("h") ? ((howlong = Long.parseLong(banTime.substring(0, banTime.length() - 1)) * hour) / hour == 1L ? "for 1 hour" : "for " + Long.toString(howlong / hour) + " hours") : (banValue.trim().equalsIgnoreCase("d") ? ((howlong = Long.parseLong(banTime.substring(0, banTime.length() - 1)) * day) / day == 1L ? "for 1 day" : "for " + Long.toString(howlong / day) + " days") : (banValue.trim().equalsIgnoreCase("w") ? ((howlong = Long.parseLong(banTime.substring(0, banTime.length() - 1)) * week) / week == 1L ? "for 1 week" : "for " + Long.toString(howlong / week) + " weeks") : (banValue.trim().equalsIgnoreCase("m") ? ((howlong = Long.parseLong(banTime.substring(0, banTime.length() - 1)) * month) / month == 1L ? "for 1 month" : "for " + Long.toString(howlong / month) + " months") : (banValue.trim().equalsIgnoreCase("y") ? ((howlong = Long.parseLong(banTime.substring(0, banTime.length() - 1)) * year) / year == 1L ? "for 1 year" : "for " + Long.toString(howlong / year) + " years") : ((howlong = Long.parseLong(banTime) * minute) / minute == 1L ? "for 1 minute" : "for " + Long.toString(howlong / minute) + " minutes")))));
            }
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:Incorrect Syntax: Syntax is as follows<br>/c banip ip#time<br>Please note the time argument can be left off and will default to 1 year<br>also note that the time argument can be made in different ways<br>/c banip X.X.X.X#10 (address is banned for 10 mins)<br>/c banip X.X.X.X#10h (address is banned for 10 hours)<br>/c banip X.X.X.X#10d (address is banned for 10 days)<br>/c banip X.X.X.X#10w (address is banned for 10 weeks)<br>/c banip X.X.X.X#10m (address is banned for 10 months)<br>/c banip X.X.X.X#10y (address is banned for 10 years)<br>/c banip X.X.X.X#perm (address is banned for a very long time)", Username);
        }
        long until = System.currentTimeMillis() + howlong;
        if (ip != null) {
            CampaignMain.cm.getServer().getBanIps().put(ip, until);
        }
        CampaignMain.cm.getServer().bansUpdate();
        CampaignMain.cm.getServer().sendChat(Username + " banned " + toKill + " " + timeName + ".");
    }
}

