/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import common.CampaignData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;
import megamek.common.Entity;
import server.campaign.CampaignMain;
import server.campaign.SUnit;
import server.campaign.commands.Command;

public class BuildTableValidatorCommand
implements Command {
    int accessLevel = 100;
    String syntax = "[Standard/Reward/Rare]";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String era = "standard";
        if (command.hasMoreTokens()) {
            era = command.nextToken();
        }
        String filePath = "./data/buildtables/";
        StringBuffer results = new StringBuffer();
        if (era.equalsIgnoreCase("all")) {
            results.append("<b>Bad filenames in " + filePath + "standard:</b><br>");
            results.append(this.validate("standard", Username) + "<br>");
            results.append("<b>Bad filenames in " + filePath + "reward:</b><br>");
            results.append(this.validate("reward", Username) + "<br>");
            results.append("<b>Bad filenames in " + filePath + "rare:</b><br>");
            results.append(this.validate("rare", Username));
        } else {
            results.append("<b>Bad filenames in " + filePath + era + ":</b><br>");
            results.append(this.validate(era, Username));
        }
        CampaignMain.cm.toUser("SM|" + results.toString(), Username, false);
    }

    private String validate(String folderName, String Username) {
        File file = new File("./data/buildtables/" + folderName);
        if (!file.exists()) {
            return file.getPath() + " does not exist. Try again.";
        }
        if (!file.isDirectory()) {
            return file.getPath() + " is not a directory. Try again.";
        }
        StringBuffer toReturn = new StringBuffer();
        File[] fileList = file.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            if (!fileList[i].isFile()) continue;
            try {
                FileReader fis = new FileReader(fileList[i]);
                BufferedReader dis = new BufferedReader(fis);
                while (dis.ready()) {
                    String line = dis.readLine();
                    if (line.trim().length() == 0) {
                        toReturn.append("Empty line! [Table: " + fileList[i].getPath() + "]<br>");
                        continue;
                    }
                    if (line.startsWith(" ")) {
                        toReturn.append("Leading space! " + line + "[Table: " + fileList[i].getPath() + "]<br>");
                        continue;
                    }
                    if (line.indexOf(".") == -1 && CampaignMain.cm.getHouseFromPartialString(line, null) != null) {
                        toReturn.append("Missing file extension? " + line + "[Table: " + fileList[i].getPath() + "]<br>");
                        continue;
                    }
                    String lowerLine = line.toLowerCase();
                    if (!(lowerLine.endsWith("mtf") || line.endsWith("blk") || line.endsWith("hmp") || line.endsWith("hmv") || line.endsWith("xml"))) {
                        toReturn.append("Unknown file extension? " + line + "[Table: " + fileList[i].getPath() + "]<br>");
                        continue;
                    }
                    String unitToBuild = line.substring(line.indexOf(" ")).trim();
                    Entity ent = SUnit.loadMech(unitToBuild);
                    if (!ent.getModel().equals("OMG-UR-FD")) continue;
                    toReturn.append("Error loading: " + unitToBuild.trim() + " [Table: " + fileList[i].getPath() + "]<br>");
                }
                continue;
            }
            catch (Exception e) {
                CampaignData.mwlog.errLog(e);
                return "Error from FileReader of BufferedReader while opening files. Check permissions.";
            }
        }
        return toReturn.toString();
    }
}

