/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class CheckCommand
implements Command {
    int accessLevel = 100;
    String syntax = "Player Name";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = null;
        try {
            p = CampaignMain.cm.getPlayer(command.nextToken());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:Improper format. Try: /c check#name", Username, true);
            return;
        }
        if (p == null) {
            CampaignMain.cm.toUser("AM:Couldn't find a user with that name.", Username, true);
            return;
        }
        String toMod = p.getColoredName() + " is currently ";
        int status = p.getDutyStatus();
        toMod = status == 4 ? toMod + "fighting. " : (status == 3 ? toMod + "active. " : toMod + "inactive. ");
        toMod = toMod + "He has " + CampaignMain.cm.moneyOrFluMessage(true, true, p.getMoney()) + ", ";
        toMod = toMod + p.getExperience() + " EXP, ";
        toMod = toMod + CampaignMain.cm.moneyOrFluMessage(false, true, p.getInfluence()) + " and ";
        toMod = toMod + p.getReward() + " RPs.<br>";
        toMod = toMod + " - Client version is " + p.getPlayerClientVersion() + ".<br>";
        toMod = toMod + " - IP addess is " + CampaignMain.cm.getServer().getIP(p.getName()) + ".<br>";
        toMod = toMod + " - Userlevel is " + CampaignMain.cm.getServer().getUserLevel(p.getName()) + ".";
        toMod = toMod + " - Multiplayer group is " + p.getGroupAllowance() + " (0 == no group).";
        CampaignMain.cm.toUser(toMod, Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " checked " + p.getName());
    }
}

