/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import common.SubFaction;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class CreateSubFactionCommand
implements Command {
    int accessLevel = 100;
    String syntax = "SubFaction Name#SubFaction AccessLevel#Faction Name";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String factionName = "";
        String subFactionName = "";
        int access = 0;
        SPlayer player = CampaignMain.cm.getPlayer(Username);
        try {
            subFactionName = command.nextToken();
            access = Integer.parseInt(command.nextToken());
            factionName = command.hasMoreTokens() && CampaignMain.cm.getServer().isModerator(Username) ? command.nextToken() : player.getMyHouse().getName();
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("AM:Invalid syntax: /CreateSubFaction SubFactionName#SubFactionAccessLevel#[FactionName]", Username);
            return;
        }
        SHouse faction = CampaignMain.cm.getHouseFromPartialString(factionName, Username);
        if (faction == null) {
            return;
        }
        if (faction.getSubFactionList().containsKey(subFactionName)) {
            return;
        }
        SubFaction subFaction = new SubFaction(subFactionName, Integer.toString(access));
        faction.getSubFactionList().put(subFactionName, subFaction);
        faction.updated();
        if (CampaignMain.cm.isUsingMySQL()) {
            CampaignMain.cm.MySQL.saveSubFaction(subFaction.toString(), faction.getDBId());
        }
        CampaignMain.cm.doSendModMail("NOTE", Username + " has created subfaction " + subFactionName + " for faction " + faction.getName());
        CampaignMain.cm.toUser("AM:You have created subfaction " + subFactionName + " for faction " + faction.getName(), Username);
    }
}

