/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import common.util.StringUtils;
import java.util.ArrayList;
import java.util.StringTokenizer;
import megamek.common.AmmoType;
import megamek.common.Entity;
import megamek.common.Mounted;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;

public class FixAmmoCommand
implements Command {
    int accessLevel = 100;
    String syntax = "Player Name#Unit ID";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int unitID;
        String targetName;
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer target = null;
        try {
            targetName = command.nextToken();
            unitID = Integer.parseInt(command.nextToken());
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("AM:Invalid Syntax: /FixAmmo Player#UnitID", Username);
            return;
        }
        target = CampaignMain.cm.getPlayer(targetName);
        if (target == null) {
            CampaignMain.cm.toUser("AM:Target player could not be found. Try again.", Username, true);
            return;
        }
        SUnit m = target.getUnit(unitID);
        if (m == null) {
            CampaignMain.cm.toUser("AM:Target player doesn't have a unit with ID# " + unitID + ".", Username, true);
            return;
        }
        this.fixAmmo(m);
        CampaignMain.cm.toUser(targetName + "'s " + m.getModelName() + "'s ammo has been fixed.", Username, true);
        CampaignMain.cm.toUser(Username + " has fixed the ammo on your " + m.getModelName() + " (ID#" + m.getId() + ")", targetName, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " fixed the ammo on " + StringUtils.aOrAn(m.getModelName(), true) + " belonging to " + targetName);
        target.setSave();
        target.checkAndUpdateArmies(m);
        CampaignMain.cm.toUser("PL|UU|" + m.getId() + "|" + m.toString(true), targetName, false);
    }

    private void fixAmmo(SUnit unit) {
        Entity baseLine = null;
        Entity en = unit.getEntity();
        baseLine = SUnit.loadMech(unit.getUnitFilename());
        ArrayList<Mounted> baseLineAmmo = baseLine.getAmmo();
        ArrayList<Mounted> currentAmmo = en.getAmmo();
        if (baseLineAmmo.size() < 1) {
            unit.getEntity().getAmmo().clear();
        }
        for (int pos = 0; pos < baseLineAmmo.size(); ++pos) {
            AmmoType baseAmmo = (AmmoType)baseLineAmmo.get(pos).getType();
            AmmoType ammo = (AmmoType)currentAmmo.get(pos).getType();
            if (ammo.getInternalName().startsWith(baseAmmo.getInternalName())) continue;
            unit.getEntity().getAmmo().set(pos, baseLineAmmo.get(pos));
        }
    }
}

