/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import java.util.StringTokenizer;
import megamek.common.Infantry;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;

public class GetPlayerUnitsCommand
implements Command {
    int accessLevel = 100;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        try {
            Command commandMethod;
            int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
            if (userLevel < this.getExecutionLevel()) {
                CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
                return;
            }
            String username = command.nextToken();
            String commandName = command.nextToken();
            String extraCommands = null;
            if (command.hasMoreTokens()) {
                extraCommands = command.nextToken();
            }
            if ((commandMethod = CampaignMain.cm.getServerCommands().get(commandName.toUpperCase())) == null) {
                CampaignMain.cm.toUser("AM:Unknown command " + commandName + ".", Username, true);
                return;
            }
            if (commandMethod.getExecutionLevel() > userLevel) {
                CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + commandMethod.getExecutionLevel() + ".", Username, true);
                return;
            }
            SPlayer target = CampaignMain.cm.getPlayer(username);
            if (target == null) {
                CampaignMain.cm.toUser("AM:Unknown user " + username + ".", Username, true);
                return;
            }
            String result = commandName + "|" + username + "|";
            for (SUnit unit : target.getUnits()) {
                if (unit.getType() == 0 || unit.getType() == 1 || unit.getType() == 5) {
                    result = result + unit.getId() + " " + unit.getModelName() + " (" + unit.getPilot().getGunnery() + "/" + unit.getPilot().getPiloting() + ")#";
                    continue;
                }
                if (unit.getType() == 2 || unit.getType() == 4) {
                    if (((Infantry)unit.getEntity()).isAntiMek()) {
                        result = result + unit.getId() + " " + unit.getModelName() + " (" + unit.getPilot().getGunnery() + "/" + unit.getPilot().getPiloting() + ")#";
                        continue;
                    }
                    result = result + unit.getId() + " " + unit.getModelName() + " (" + unit.getPilot().getGunnery() + ")#";
                    continue;
                }
                result = result + unit.getId() + " " + unit.getModelName() + " (" + unit.getPilot().getGunnery() + ")#";
            }
            if (extraCommands != null) {
                result = result + "|" + extraCommands;
            }
            CampaignMain.cm.toUser("LPU|" + result, Username, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

