/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.commands.Command;

public class GrantTechPointsCommand
implements Command {
    int accessLevel = 100;
    String syntax = "Faction Name#Amount";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SHouse faction = CampaignMain.cm.getHouseFromPartialString(command.nextToken(), Username);
        int amount = Integer.parseInt(command.nextToken());
        if (faction != null) {
            faction.addTechResearchPoint(amount);
            String toRecipient = "AM:" + Username + " granted you " + amount + " Tech Research Points";
            CampaignMain.cm.doSendHouseMail(faction, "NOTE", toRecipient);
            if (faction.getTechResearchPoints() >= CampaignMain.cm.getIntegerConfig("TechPointsNeedToLevel")) {
                faction.updateHouseTechLevel();
                CampaignMain.cm.doSendHouseMail(faction, "NOTE", Username + " has increased your factions Tech Level!");
            }
            CampaignMain.cm.toUser("AM:You granted " + amount + " Tech Research Points to " + faction.getName(), Username, true);
            CampaignMain.cm.doSendModMail("NOTE", Username + " granted " + amount + " Tech Research Points to " + faction.getName());
        }
    }
}

