/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import common.util.UnitUtils;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class GrantTechsCommand
implements Command {
    int accessLevel = 100;
    String syntax = "Player Name#Tech Type#Amount";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(command.nextToken());
        int techType = Integer.parseInt(command.nextToken());
        int amount = Integer.parseInt(command.nextToken());
        if (amount < 0 && p.getTotalTechs().elementAt(techType) < Math.abs(amount)) {
            amount = -p.getTotalTechs().elementAt(techType).intValue();
        }
        p.addTotalTechs(techType, amount);
        p.addAvailableTechs(techType, amount);
        CampaignMain.cm.toUser("AM:" + Username + " has granted you " + amount + " " + UnitUtils.techDescription(techType) + " techs.", p.getName());
        CampaignMain.cm.doSendModMail("NOTE", Username + " has granted " + p.getName() + " " + amount + " " + UnitUtils.techDescription(techType) + " techs.");
    }
}

