/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import common.CampaignData;
import java.util.StringTokenizer;
import server.MWChatServer.MWChatServer;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;

public class KickCommand
implements Command {
    int accessLevel = 100;
    String syntax = "Player Name";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String toKick = null;
        try {
            toKick = command.nextToken();
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper format. Try: /c kick#NAME", Username);
            return;
        }
        if (CampaignMain.cm.getServer().isAdmin(toKick) && !Username.startsWith("[Dedicated]")) {
            CampaignMain.cm.toUser("AM:You may not kick an admin.", Username);
            return;
        }
        CampaignMain.cm.toUser("AM:You were kicked by " + Username, toKick, true);
        CampaignMain.cm.toUser("PL|GBB|Bye Bye", toKick, false);
        CampaignMain.cm.getServer().sendRemoveUserToAll(toKick, false);
        CampaignMain.cm.getServer().sendChat("AM:" + Username + " kicked " + toKick);
        CampaignData.mwlog.modLog(Username + " kicked " + toKick);
        try {
            CampaignMain.cm.getOpsManager().doDisconnectCheckOnPlayer(toKick);
            CampaignMain.cm.doLogoutPlayer(toKick);
            if (CampaignMain.cm.getServer().getClient(MWChatServer.clientKey(toKick)) != null) {
                CampaignMain.cm.getServer().killClient(toKick, Username);
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }
}

