/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import common.House;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class ListMultiPlayerGroupsCommand
implements Command {
    int accessLevel = 100;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String toSend = "AM:List of Multiplayergroups:";
        Hashtable<String, SPlayer> allPlayers = new Hashtable<String, SPlayer>();
        for (House vh : CampaignMain.cm.getData().getAllHouses()) {
            SHouse h = (SHouse)vh;
            allPlayers.putAll(h.getAllOnlinePlayers());
        }
        Hashtable<Integer, Vector> result = new Hashtable<Integer, Vector>();
        Enumeration e = allPlayers.elements();
        while (e.hasMoreElements()) {
            SPlayer p = (SPlayer)e.nextElement();
            if (p.getGroupAllowance() == 0) continue;
            Vector v = result.get(p.getGroupAllowance()) == null ? new Vector(1, 1) : (Vector)result.get(p.getGroupAllowance());
            v.add(p);
            result.put(p.getGroupAllowance(), v);
        }
        Enumeration groups = result.keys();
        while (groups.hasMoreElements()) {
            Integer GroupID = (Integer)groups.nextElement();
            Vector members = (Vector)result.get(GroupID);
            toSend = toSend + "<br>Group #" + GroupID + ":";
            for (int i = 0; i < members.size(); ++i) {
                SPlayer p = (SPlayer)members.elementAt(i);
                toSend = toSend + p.getName() + " + ";
            }
            toSend = toSend.substring(0, toSend.lastIndexOf("+") - 1);
        }
        CampaignMain.cm.toUser(toSend, Username, true);
    }
}

