/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class ModDeactivateCommand
implements Command {
    int accessLevel = 100;
    String syntax = "Player Name";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String targetPlayerString = (String)command.nextElement();
        SPlayer targetPlayer = CampaignMain.cm.getPlayer(targetPlayerString);
        if (targetPlayer == null) {
            CampaignMain.cm.toUser(targetPlayerString + " cannot be found.", Username, true);
            return;
        }
        if (targetPlayer.getDutyStatus() == 4) {
            CampaignMain.cm.toUser(targetPlayerString + " is fighting. Cancel his game before deactivating.", Username, true);
            return;
        }
        if (targetPlayer.getDutyStatus() != 3) {
            CampaignMain.cm.toUser("Target player is logged out or is already in reserve state. Nice try though.", Username, true);
            return;
        }
        targetPlayer.setActive(false);
        CampaignMain.cm.toUser(Username + " forced you to return to reserve duty.", targetPlayerString, true);
        CampaignMain.cm.toUser("You forced " + targetPlayerString + " into reserve status.", Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " force-deactivated " + targetPlayerString + ".'");
        CampaignMain.cm.sendPlayerStatusUpdate(targetPlayer, new Boolean(CampaignMain.cm.getConfig("HideActiveStatus")) == false);
    }
}

