/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import java.util.StringTokenizer;
import megamek.common.Entity;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;

public class ModFullRepairCommand
implements Command {
    int accessLevel = 200;
    String syntax = "Player Name#Unit ID";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String targetName = (String)command.nextElement();
        SPlayer target = CampaignMain.cm.getPlayer(targetName);
        if (target == null) {
            CampaignMain.cm.toUser("AM:Target player could not be found. Try again.", Username, true);
            return;
        }
        int unitID = Integer.parseInt((String)command.nextElement());
        SUnit m = target.getUnit(unitID);
        if (m == null) {
            CampaignMain.cm.toUser("AM:Target player doesn't have a unit with ID# " + unitID + ".", Username, true);
            return;
        }
        Entity unitEntity = SUnit.loadMech(m.getUnitFilename());
        m.setEntity(unitEntity);
        CampaignMain.cm.toUser("AM:" + targetName + "'s " + m.getModelName() + " is now fully repaired.", Username, true);
        CampaignMain.cm.toUser("AM:" + Username + " mod-repaired your " + m.getModelName() + " (ID#" + m.getId() + ")", targetName, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " mod-repaired a " + m.getModelName() + " belonging to " + targetName);
        target.setSave();
        target.checkAndUpdateArmies(m);
        CampaignMain.cm.toUser("PL|UU|" + m.getId() + "|" + m.toString(true), targetName, false);
    }
}

