/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.operations.ShortOperation;

public class ModGamesCommand
implements Command {
    int accessLevel = 100;
    String syntax = "[Faction]";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        if (p == null) {
            CampaignMain.cm.toUser("Null player. Contact an administrator to report this, immediately!", Username, true);
            return;
        }
        boolean factionSort = false;
        String factionName = "";
        if (command.hasMoreElements()) {
            try {
                factionName = command.nextToken().toLowerCase();
                if (!factionName.equals("") && !factionName.startsWith(" ")) {
                    factionSort = true;
                }
            }
            catch (Exception ex) {
                CampaignMain.cm.toUser("Games command failed. Check your input. It should be:/c modames (to get all games) or /c modgames#faction (for a filtered list)", Username, true);
                return;
            }
        }
        String runningGames = "<h2>Running Games (MOD VIEW):</h2><br>";
        String finishedGames = "<h2>Finished Games (MOD VIEW):</h2><br>";
        int runningGamesCount = 0;
        int finishedGamesCount = 0;
        for (ShortOperation currO : CampaignMain.cm.getOpsManager().getRunningOps().values()) {
            if (factionSort && !currO.hasPlayerWhoseHouseBeginsWith(factionName)) continue;
            String currInfo = "";
            currInfo = currInfo + currO.getInfo(true, true) + "<br>";
            if (currO.getStatus() == ShortOperation.STATUS_FINISHED) {
                finishedGames = finishedGames + currInfo;
                ++finishedGamesCount;
                continue;
            }
            runningGames = runningGames + currInfo;
            ++runningGamesCount;
        }
        if (runningGamesCount == 0) {
            runningGames = runningGames + "- None<br>";
        }
        if (finishedGamesCount == 0) {
            finishedGames = finishedGames + "- None<br>";
        }
        CampaignMain.cm.toUser("SM|" + runningGames + finishedGames, Username, false);
        CampaignMain.cm.doSendModMail("NOTE", Username + " used /c modgames.");
    }
}

