/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import java.io.File;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.util.ExclusionList;

public class ModNoPlayCommand
implements Command {
    int accessLevel = 100;
    String syntax = "mode[add/remove]#lister#excludee";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String mode = "";
        try {
            mode = command.nextToken().toLowerCase();
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper format. Try: /c noplay#mode#lister#excludee", Username, true);
            return;
        }
        String listerName = "";
        try {
            listerName = command.nextToken().toLowerCase();
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper format. Try: /c noplay#mode#lister#excludee", Username, true);
            return;
        }
        String excludeName = "";
        try {
            excludeName = command.nextToken().toLowerCase();
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper format. Try: /c noplay#mode#lister#excludee", Username, true);
            return;
        }
        SPlayer lister = CampaignMain.cm.getPlayer(listerName);
        if (lister == null) {
            CampaignMain.cm.toUser("Couldn't find " + listerName, Username, true);
            return;
        }
        ExclusionList exList = lister.getExclusionList();
        if (exList == null) {
            CampaignMain.cm.toUser("ERROR. " + listerName + "'s no-play list was null.", Username, true);
            return;
        }
        int exclusionStatus = exList.checkExclude(excludeName);
        if (mode.equals("add")) {
            boolean playerExists = false;
            playerExists = !CampaignMain.cm.isUsingMySQL() ? new File("./campaign/players/" + excludeName.toLowerCase() + ".dat").exists() : CampaignMain.cm.MySQL.playerExists(excludeName);
            if (!playerExists) {
                CampaignMain.cm.toUser(excludeName + " does not have a player file. cannot add to your no-play list.", Username, true);
                return;
            }
            if (listerName.toLowerCase().equals(excludeName)) {
                CampaignMain.cm.toUser("You can't put someone on his own no-play list. Jackass.", Username, true);
                return;
            }
            if (exclusionStatus == 2) {
                CampaignMain.cm.toUser(excludeName + " is already on " + listerName + "'s mod/admin no-play list.", Username, true);
                return;
            }
            if (exclusionStatus == 1) {
                exList.removeExclude(true, excludeName);
                CampaignMain.cm.toUser(Username + " removed " + excludeName + " from your no-play list.", listerName, true);
                CampaignMain.cm.toUser("PL|PEU|" + lister.getExclusionList().playerExcludeToString("$"), listerName, false);
            }
            try {
                exList.addExclude(true, excludeName);
                CampaignMain.cm.toUser(Username + " added " + excludeName + " to your mod/admin no-play list. You cannot alter this entry.", listerName, true);
                CampaignMain.cm.toUser(Username + " added you to " + listerName + "'s mod/admin no-play list. He cannot alter this entry.", excludeName, true);
                CampaignMain.cm.toUser(excludeName + " added to " + listerName + "'s mod/admin no-play list.", Username, true);
                CampaignMain.cm.toUser("PL|AEU|" + lister.getExclusionList().adminExcludeToString("$"), listerName, false);
                lister.setSave();
                CampaignMain.cm.doSendModMail("NOTE", Username + " added " + excludeName + " to " + listerName + "'s mod/admin no-play list.");
            }
            catch (Exception e) {
                CampaignMain.cm.toUser("Error while adding " + excludeName + " to " + listerName + "'s no-play list.", Username, true);
            }
        } else if (mode.equals("remove")) {
            if (exclusionStatus == 0) {
                CampaignMain.cm.toUser(excludeName + " is not on either of " + listerName + "'s no-play lists.", Username, true);
                return;
            }
            try {
                exList.removeExclude(true, excludeName);
                if (exclusionStatus == 2) {
                    CampaignMain.cm.toUser(Username + " removed " + excludeName + " from your Mod/Admin no-play list.", listerName, true);
                    CampaignMain.cm.toUser(Username + " removed you from " + listerName + "'s Mod/Admin no-play list.", excludeName, true);
                    CampaignMain.cm.toUser("Your removed " + excludeName + " from " + listerName + "'s Mod/Admin no-play list.", Username, true);
                    CampaignMain.cm.toUser("PL|AEU|" + lister.getExclusionList().adminExcludeToString("$"), listerName, false);
                    CampaignMain.cm.doSendModMail("NOTE", Username + " removed " + excludeName + " from " + listerName + "'s Mod/Admin no-play list.");
                } else {
                    CampaignMain.cm.toUser(Username + " removed " + excludeName + " from your no-play list.", listerName, true);
                    CampaignMain.cm.toUser("You removed " + excludeName + " from " + listerName + "'s standard no-play list.", Username, true);
                    CampaignMain.cm.toUser("PL|PEU|" + lister.getExclusionList().playerExcludeToString("$"), listerName, false);
                    CampaignMain.cm.doSendModMail("NOTE", Username + " removed " + excludeName + " from " + listerName + "'s standard no-play list.");
                }
                lister.setSave();
            }
            catch (Exception e) {
                CampaignMain.cm.toUser("Error while removing " + excludeName + " from " + listerName + "'s no-play list.", Username, true);
                return;
            }
        } else {
            CampaignMain.cm.toUser("Improper format. Try: /c noplay#mode#lister#excludee", Username, true);
            return;
        }
    }
}

