/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlanet;
import server.campaign.SUnitFactory;
import server.campaign.commands.Command;

public class ModRefreshFactoryCommand
implements Command {
    int accessLevel = 100;
    String syntax = "Planet Name#Factory Name";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        String factoryName;
        String planetName;
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        try {
            planetName = command.nextToken();
            factoryName = command.nextToken();
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper format. Try: /c modrefreshfactory#planetname#factoryname", Username, true);
            return;
        }
        SPlanet p = (SPlanet)CampaignMain.cm.getData().getPlanetByName(planetName);
        if (p == null) {
            CampaignMain.cm.toUser("Could not find planet: " + planetName + ".", Username, true);
            return;
        }
        SUnitFactory uf = (SUnitFactory)CampaignMain.cm.getData().getFactoryByName(p, factoryName);
        if (uf == null) {
            CampaignMain.cm.toUser("Could not find factory: " + factoryName + ".", Username, true);
            return;
        }
        int ticksToRemove = uf.getTicksUntilRefresh();
        String refresh = uf.addRefresh(-ticksToRemove, true);
        if (p.getOwner() != null) {
            CampaignMain.cm.doSendToAllOnlinePlayers(p.getOwner(), "HS|" + refresh, false);
        }
        CampaignMain.cm.doSendModMail("NOTE", Username + " has refreshed factory " + uf.getName() + " on planet " + p.getName() + "!");
    }
}

