/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.operations.ShortOperation;

public class ModTerminateCommand
implements Command {
    int accessLevel = 100;
    String syntax = "Game Number";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        int opID = -1;
        try {
            opID = Integer.parseInt(command.nextToken());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper format. Try: /c modterminate#game number", Username, true);
            return;
        }
        SPlayer tp = CampaignMain.cm.getPlayer(Username);
        if (tp == null) {
            CampaignMain.cm.toUser("Null player. Report this immediately!", Username, true);
            return;
        }
        ShortOperation so = CampaignMain.cm.getOpsManager().getRunningOps().get(opID);
        if (so == null) {
            CampaignMain.cm.toUser("AM:Terminate failed. Attack #" + opID + " does not exist.", Username, true);
            return;
        }
        if (so.getStatus() == ShortOperation.STATUS_FINISHED) {
            CampaignMain.cm.toUser("AM:Terminate failed. You may not terminate a completed game.", Username, true);
            return;
        }
        CampaignMain.cm.getOpsManager().terminateOperation(so, 0, tp);
        String players = "Players were ";
        int playerCounter = 1;
        int totalPlayers = so.getAllPlayerNames().size();
        for (String currPlayerName : so.getAllPlayerNames()) {
            players = players + currPlayerName;
            if (++playerCounter == totalPlayers) {
                players = players + " and ";
                continue;
            }
            if (playerCounter > totalPlayers) {
                players = players + ".";
                continue;
            }
            players = players + ", ";
        }
        CampaignMain.cm.toUser("AM:You terminated Attack #" + opID + ". " + players, Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " terminated Attack #" + opID + ". " + players);
    }
}

