/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class RemoveLeaderCommand
implements Command {
    int accessLevel = 100;
    String syntax = "Player Name";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        try {
            String target = command.nextToken();
            SPlayer player = CampaignMain.cm.getPlayer(target);
            player.getMyHouse().removeLeader(player.getName());
            int level = CampaignMain.cm.getIntegerConfig("factionLeaderLevel");
            if (player.getPassword().getAccess() <= level) {
                level = 2;
                CampaignMain.cm.updatePlayersAccessLevel(target, level);
            }
            CampaignMain.cm.toUser("AM:You have been demoted as a faction leader by " + Username + ".", target);
            CampaignMain.cm.doSendHouseMail(player.getMyHouse(), "Note", player.getName() + " has been demoted from the faction leadership.");
            CampaignMain.cm.doSendModMail("NOTE", Username + " has removed " + player.getName() + " as a faction leader.");
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("Invalid syntax: /addleader UserName", Username);
        }
    }
}

