/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class RemoveSubFactionCommand
implements Command {
    int accessLevel = 100;
    String syntax = "Faction name#Sub Faction Name";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String factionName = "";
        String subFactionName = "";
        SPlayer player = CampaignMain.cm.getPlayer(Username);
        try {
            subFactionName = command.nextToken();
            factionName = command.hasMoreTokens() && CampaignMain.cm.getServer().isModerator(Username) ? command.nextToken() : player.getMyHouse().getName();
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("AM:Invalid syntax: /RemoveSubFaction SubFactionName#[FactionName]", Username);
            return;
        }
        SHouse faction = CampaignMain.cm.getHouseFromPartialString(factionName, Username);
        if (faction == null) {
            return;
        }
        faction.getSubFactionList().remove(subFactionName);
        faction.updated();
        if (CampaignMain.cm.isUsingMySQL()) {
            CampaignMain.cm.MySQL.deleteSubFaction(subFactionName, faction.getDBId());
        }
        CampaignMain.cm.doSendModMail("NOTE", Username + " has removed subfaction " + subFactionName + " for faction " + faction.getName());
        CampaignMain.cm.toUser("AM:You have removed subfaction " + subFactionName + " for faction " + faction.getName(), Username);
    }
}

