/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import common.Unit;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.commands.Command;

public class SetHouseBasePilotSkillsCommand
implements Command {
    int accessLevel = 100;
    String syntax = "Faction Name#Pilot Type#Gunnery#Piloting";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int piloting;
        int gunnery;
        int pilotType;
        SHouse house;
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        try {
            house = CampaignMain.cm.getHouseFromPartialString(command.nextToken(), Username);
            pilotType = Integer.parseInt(command.nextToken());
            gunnery = Integer.parseInt(command.nextToken());
            piloting = Integer.parseInt(command.nextToken());
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("Invalid Syntax: sethousebasepilotskills house#pilotType#Gunnery#Piloting", Username);
            return;
        }
        if (house == null) {
            return;
        }
        if (pilotType >= 6 || pilotType < 0) {
            CampaignMain.cm.toUser("Invalid unit type:<br>Mek 0<br>Vehicle 1<br>Infantry 2<br>Battle Armor 4<br>ProtoMek 3<br>Aero 5", Username);
            return;
        }
        house.getPilotQueues().setBaseGunnery(gunnery, pilotType);
        house.getPilotQueues().setBasePiloting(piloting, pilotType);
        CampaignMain.cm.toUser("You set have set the gunnery and piloting for unit " + Unit.getTypeClassDesc(pilotType) + " for house " + house.getName() + " to " + gunnery + "/" + piloting, Username);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has set the gunnery and piloting for unit " + Unit.getTypeClassDesc(pilotType) + " for house " + house.getName() + " to " + gunnery + "/" + piloting + ".");
    }
}

