/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.mercenaries.ContractInfo;
import server.campaign.mercenaries.MercHouse;

public class TerminateContractCommand
implements Command {
    int accessLevel = 100;
    String syntax = "Player Name";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(command.nextToken());
        SHouse faction = p.getMyHouse();
        if (!faction.isMercHouse()) {
            CampaignMain.cm.toUser("Only mercenary players have contracts. Nice try, though.", Username, true);
            return;
        }
        MercHouse mercFaction = (MercHouse)faction;
        ContractInfo contract = mercFaction.getContractInfo(p);
        if (contract == null) {
            CampaignMain.cm.toUser(p.getName() + " has no contract to cancel", Username, true);
            return;
        }
        int payment = contract.getPayment();
        SHouse employer = contract.getEmployingHouse();
        int refund = (int)((double)payment * 0.5);
        SPlayer contractingPlayer = contract.getOfferingPlayer();
        if (contractingPlayer != null) {
            contractingPlayer.addMoney(refund);
            CampaignMain.cm.toUser(Username + " abrogated your contract with" + contract.getEmployingHouse().getName() + ". Funds returned from escrow (" + CampaignMain.cm.moneyOrFluMessage(true, true, refund, true) + ").", p.getName(), true);
        } else {
            contract.getEmployingHouse().setMoney(employer.getMoney() + refund);
        }
        mercFaction.endContract(p);
        CampaignMain.cm.toUser(Username + " abrogated your contract with" + contract.getEmployingHouse().getName() + ".", p.getName(), true);
        CampaignMain.cm.toUser("You revoked " + p.getName() + "'s contract with" + contract.getEmployingHouse().getName() + ".", Username, true);
    }
}

