/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;

public class UnBanCommand
implements Command {
    int accessLevel = 100;
    String syntax = "Player Name";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        try {
            String account = command.nextToken().toLowerCase();
            if (CampaignMain.cm.getServer().getBanAccounts().get(account) != null) {
                CampaignMain.cm.getServer().getBanAccounts().remove(account);
                CampaignMain.cm.getServer().bansUpdate();
                CampaignMain.cm.doSendModMail("NOTE", Username + " unbanned " + account);
                CampaignMain.cm.toUser("AM:You unbanned " + account, Username);
                CampaignMain.cm.toUser("AM:Don't forget to unban any assotiated IP's as well with the unbanip command", Username);
            } else {
                CampaignMain.cm.toUser("AM:Unban failed for " + account, Username);
                CampaignMain.cm.doSendModMail("NOTE", Username + " tried to uban " + account + ", but failed.");
            }
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("AM:Syntax: unban (Username)<br>Don't forget to unban any assotiated IP's as well with the unbanip command", Username);
        }
    }
}

