/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class ValidateUserCommand
implements Command {
    int accessLevel = 100;
    String syntax = "Player Name";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (!CampaignMain.cm.isUsingMySQL()) {
            CampaignMain.cm.toUser("AM:This server is not database-enabled.", Username, true);
            return;
        }
        if (!CampaignMain.cm.isSynchingBB()) {
            CampaignMain.cm.toUser("AM:This server is not synching with phpBB.", Username, true);
            return;
        }
        if (!command.hasMoreTokens()) {
            CampaignMain.cm.toUser("AM:Syntax: /ValidateUser Username", Username, true);
            return;
        }
        String pName = command.nextToken();
        SPlayer p = CampaignMain.cm.getPlayer(pName);
        if (p == null) {
            CampaignMain.cm.toUser("AM:Unable to find player " + pName + ".", Username, true);
            return;
        }
        if (p.isValidated()) {
            CampaignMain.cm.toUser("AM:" + pName + " is already validated.", Username, true);
            return;
        }
        p.setUserValidated(true);
        CampaignMain.cm.MySQL.validateUser(p.getForumID());
        p.setSave();
        CampaignMain.cm.toUser("AM:" + pName + " has been validated.", Username, true);
        CampaignMain.cm.toUser("AM: " + Username + " has validated your account.", pName, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has validated " + pName + "'s account.");
    }
}

