/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import common.util.UnitUtils;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;

public class ViewPlayerUnitCommand
implements Command {
    int accessLevel = 100;
    String syntax = "Player Name#Unit ID#Show Damage[true/false]";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int unitId;
        SPlayer p;
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        boolean damage = false;
        try {
            p = CampaignMain.cm.getPlayer(command.nextToken());
            unitId = Integer.parseInt(command.nextToken());
            damage = Boolean.parseBoolean(command.nextToken());
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("Syntax: ViewPlayerUnit#Name#UnitID#ShowDamage[true/false]", Username);
            return;
        }
        if (p == null) {
            CampaignMain.cm.toUser("Player does not exist!", Username);
            return;
        }
        SUnit unit = p.getUnit(unitId);
        if (unit == null) {
            CampaignMain.cm.toUser(p.getName() + " does not have unit #" + unitId, Username);
            return;
        }
        String fileName = unit.getEntity().getChassis() + " " + unit.getEntity().getModel();
        if (!damage) {
            CampaignMain.cm.toUser("PL|VUI|" + fileName + "#" + unit.getBV() + "#" + unit.getPilot().getGunnery() + "#" + unit.getPilot().getPiloting() + "#" + UnitUtils.unitBattleDamage(unit.getEntity()), Username, false);
        } else {
            CampaignMain.cm.toUser("PL|VURD|" + fileName + "#" + UnitUtils.unitBattleDamage(unit.getEntity()), Username, false);
        }
        CampaignMain.cm.doSendModMail("NOTE", Username + " has viewed " + p.getName() + "'s " + unit.getModelName());
        CampaignMain.cm.toUser(Username + " has viewed your " + unit.getModelName() + ".", p.getName());
    }
}

