/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.market2;

import common.CampaignData;
import common.Unit;
import common.util.UnitUtils;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import server.campaign.BuildTable;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.market2.HighestSealedBidAuction;
import server.campaign.market2.IAuction;
import server.campaign.market2.IBuyer;
import server.campaign.market2.MarketBid;
import server.campaign.market2.MarketListing;
import server.campaign.market2.VickreyAuction;
import server.campaign.pilot.SPilot;

public class Market2 {
    private IAuction auctionType = CampaignMain.cm.getBooleanConfig("UseVickeryAuctionType") ? new VickreyAuction() : (CampaignMain.cm.getBooleanConfig("UseHighestSealedBidAuctionType") ? new HighestSealedBidAuction() : new VickreyAuction());
    private TreeMap<Integer, MarketListing> currentAuctions = new TreeMap();

    public void addListing(String sellername, SUnit unit, int minbid, int salesticks) {
        this.addListing(sellername, unit, minbid, salesticks, false);
    }

    public void addListing(String sellername, SUnit unit, int minbid, int salesticks, boolean tickListing) {
        SPlayer sellingPlayer = null;
        if (!sellername.toLowerCase().startsWith("faction_") && CampaignMain.cm.getHouseFromPartialString(sellername, null) == null) {
            sellingPlayer = CampaignMain.cm.getPlayer(sellername);
        }
        if (unit.getModelName().startsWith("Error") || unit.getModelName().startsWith("OMG")) {
            CampaignData.mwlog.errLog("OMG unit trying to be sold on the BM " + unit.getProducer());
            return;
        }
        if ((!UnitUtils.canStartUp(unit.getEntity()) || UnitUtils.hasArmorDamage(unit.getEntity()) || UnitUtils.hasCriticalDamage(unit.getEntity())) && !CampaignMain.cm.getBooleanConfig("AllowDonatingOfDamagedUnits")) {
            CampaignData.mwlog.errLog("Damaged unit trying to be sold on the BM " + unit.getProducer());
            if (sellingPlayer != null) {
                CampaignMain.cm.toUser("You cannot sell damaged units on the Black Market!", sellername, true);
            }
            return;
        }
        int auctionID = this.getFreeID();
        unit.setStatus(3);
        MarketListing newAuction = new MarketListing(sellername, unit, minbid, salesticks);
        this.currentAuctions.put(auctionID, newAuction);
        if (tickListing) {
            newAuction.increaseSaleTicks();
            CampaignMain.cm.doSendToAllOnlinePlayers("BM|AU|" + newAuction.toString(auctionID, null), false);
            newAuction.decreaseSaleTicks();
        } else {
            CampaignMain.cm.doSendToAllOnlinePlayers("BM|AU|" + newAuction.toString(auctionID, null), false);
        }
        if (sellingPlayer != null) {
            CampaignMain.cm.toUser("BM|CU|" + newAuction.toString(auctionID, sellingPlayer), sellername, false);
            CampaignMain.cm.toUser("PL|SUS|" + unit.getId() + "#" + 3, sellername, false);
        }
    }

    public void removeListing(int auctionID) {
        this.removeListing(auctionID, false);
    }

    private void removeListing(int auctionID, boolean destroyFactionUnits) {
        MarketListing currAuction = this.currentAuctions.get(auctionID);
        String sellerName = currAuction.getSellerName();
        if (!sellerName.equalsIgnoreCase("rare") && !sellerName.toLowerCase().startsWith("faction_")) {
            IBuyer seller = null;
            seller = CampaignMain.cm.getHouseFromPartialString(sellerName, null);
            if (seller == null) {
                seller = CampaignMain.cm.getPlayer(sellerName);
            }
            if (seller == null) {
                return;
            }
            SUnit auctionU = seller.getUnit(currAuction.getListedUnitID());
            if (auctionU == null) {
                this.currentAuctions.remove(auctionID);
                CampaignMain.cm.doSendToAllOnlinePlayers("BM|RU|" + auctionID, false);
                return;
            }
            auctionU.setStatus(1);
            if (seller.isHuman()) {
                SPlayer p = (SPlayer)seller;
                CampaignMain.cm.toUser("PL|SUS|" + auctionU.getId() + "#" + 1, sellerName, false);
                p.setSave();
            } else {
                SHouse h = (SHouse)seller;
                if (destroyFactionUnits) {
                    h.removeUnit(auctionU, false);
                    if (CampaignMain.cm.isUsingMySQL()) {
                        CampaignMain.cm.MySQL.deleteUnit(auctionU.getDBId());
                    }
                } else {
                    CampaignMain.cm.doSendToAllOnlinePlayers(h, "HS|" + h.getHSUnitAdditionString(auctionU), false);
                }
            }
        } else {
            SHouse sellingFaction = CampaignMain.cm.getHouseFromPartialString(CampaignMain.cm.getConfig("NewbieHouseName"), null);
            SUnit auctionU = sellingFaction.getUnit(currAuction.getListedUnitID());
            if (auctionU != null) {
                sellingFaction.removeUnit(auctionU, false);
                if (CampaignMain.cm.isUsingMySQL()) {
                    CampaignMain.cm.MySQL.deleteUnit(auctionU.getDBId());
                }
            }
        }
        this.currentAuctions.remove(auctionID);
        CampaignMain.cm.doSendToAllOnlinePlayers("BM|RU|" + auctionID, false);
    }

    public void removeAllListings() {
        ArrayList<Integer> listingsToRemove = new ArrayList<Integer>();
        for (Integer currAuctionID : this.currentAuctions.keySet()) {
            listingsToRemove.add(currAuctionID);
        }
        for (Integer idToRemove : listingsToRemove) {
            this.removeListing(idToRemove);
        }
    }

    public void removePlayerListings(SPlayer p) {
        ArrayList<Integer> listingsToRemove = new ArrayList<Integer>();
        for (Integer currAuctionID : this.currentAuctions.keySet()) {
            MarketListing currL = this.currentAuctions.get(currAuctionID);
            if (!currL.getSellerName().equalsIgnoreCase(p.getName())) continue;
            listingsToRemove.add(currAuctionID);
        }
        for (Integer idToRemove : listingsToRemove) {
            this.removeListing(idToRemove);
        }
    }

    public MarketListing getListingForUnit(int unitID) {
        for (MarketListing currList : this.currentAuctions.values()) {
            if (currList.getListedUnitID() != unitID) continue;
            return currList;
        }
        return null;
    }

    public MarketListing getListingByID(int auctionID) {
        return this.currentAuctions.get(auctionID);
    }

    public boolean hasActiveListings(SPlayer player) {
        for (MarketListing currList : this.currentAuctions.values()) {
            if (!currList.getSellerName().equalsIgnoreCase(player.getName())) continue;
            return true;
        }
        return false;
    }

    public int getPlayerBidOnAuction(String playerName, int auctionID) {
        MarketListing currList = this.currentAuctions.get(auctionID);
        if (currList == null) {
            return 0;
        }
        MarketBid playersBid = currList.getAllBids().get(playerName.toLowerCase());
        if (playersBid == null) {
            return 0;
        }
        return playersBid.getAmount();
    }

    public String getPlayerBidsString(String playerName) {
        String result = "Current Bids:<br> ";
        for (Integer currListID : this.currentAuctions.keySet()) {
            MarketListing currList = this.currentAuctions.get(currListID);
            Integer currBid = currList.getAllBids().get(playerName.toLowerCase()).getAmount();
            if (currBid == null || currBid <= 0) continue;
            result = result + "You bid " + currBid + " for " + currList.getListedModelName() + " (Auction #" + currListID + ")<br>";
        }
        return result;
    }

    public String getMarketInfoString() {
        String result = "<font color=\"black\">Black Market: <br>";
        for (Integer currListID : this.currentAuctions.keySet()) {
            MarketListing currList = this.currentAuctions.get(currListID);
            result = result + "#" + currListID + " " + currList.getListedModelName() + ". Minimum Bid: ";
            result = result + currList.getMinBid() + ", Remaining Ticks: " + currList.getSaleTicks();
            result = result + ", Comment: <br>";
        }
        result = result + "</font>";
        return result;
    }

    private int getFreeID() {
        boolean foundID = false;
        int potentialID = 0;
        while (!foundID) {
            if (this.currentAuctions.get(potentialID) == null) {
                foundID = true;
                continue;
            }
            ++potentialID;
        }
        return potentialID;
    }

    public void tick() {
        ArrayList<Integer> listingsToRemove = new ArrayList<Integer>();
        ReentrantLock lock = new ReentrantLock();
        lock.lock();
        for (Integer currAuctionID : this.currentAuctions.keySet()) {
            MarketListing currList = this.currentAuctions.get(currAuctionID);
            if (currList == null) {
                listingsToRemove.add(currAuctionID);
                continue;
            }
            try {
                SPlayer p;
                SUnit unitForSale;
                currList.decreaseSaleTicks();
                if (currList.getSaleTicks() >= 0) continue;
                MarketBid winningBid = this.auctionType.getWinner(currList);
                IBuyer sellingActor = null;
                if (currList.getSellerName().toLowerCase().startsWith("faction_")) {
                    sellingActor = CampaignMain.cm.getHouseFromPartialString(currList.getSellerName().substring(8), null);
                }
                if (sellingActor == null) {
                    sellingActor = CampaignMain.cm.getHouseFromPartialString(currList.getSellerName(), null);
                }
                if (sellingActor == null) {
                    sellingActor = CampaignMain.cm.getPlayer(currList.getSellerName());
                }
                if ((unitForSale = sellingActor.getUnit(currList.getListedUnitID())) == null) {
                    CampaignData.mwlog.errLog("Unable to get unit for sale " + currList.getListedModelName() + " seller " + currList.getSellerName());
                    listingsToRemove.add(currAuctionID);
                    continue;
                }
                if (winningBid == null) {
                    if (sellingActor.isHuman()) {
                        CampaignMain.cm.toUser("No one purchased your " + currList.getListedModelName() + ".", currList.getSellerName(), true);
                        SPlayer p2 = (SPlayer)sellingActor;
                        CampaignMain.cm.toUser("PL|SUS|" + currAuctionID + "#" + 1, p2.getName(), false);
                        p2.setSave();
                    }
                    listingsToRemove.add(currAuctionID);
                    continue;
                }
                Comparable<Object> buyingActor = CampaignMain.cm.getPlayer(winningBid.getBidderName());
                if (buyingActor == null) {
                    buyingActor = CampaignMain.cm.getHouseFromPartialString(winningBid.getBidderName(), null);
                }
                int winningBidAmt = winningBid.getAmount();
                float auctionFee = CampaignMain.cm.getFloatConfig("AuctionFee");
                int auctionFeeAmt = Math.round((float)winningBidAmt * auctionFee);
                int winnerMoneyGain = winningBidAmt - auctionFeeAmt;
                buyingActor.addMoney(-winningBidAmt);
                sellingActor.addMoney(winnerMoneyGain);
                unitForSale.setStatus(1);
                if (sellingActor.isHuman()) {
                    CampaignMain.cm.toUser("The " + currList.getListedModelName() + " sold for " + CampaignMain.cm.moneyOrFluMessage(true, true, winningBidAmt) + ". Auction fees were " + CampaignMain.cm.moneyOrFluMessage(true, true, auctionFeeAmt) + ", leaving " + CampaignMain.cm.moneyOrFluMessage(true, true, winnerMoneyGain) + " as your take from " + "the sale.", currList.getSellerName(), true);
                }
                if (buyingActor.isHuman()) {
                    CampaignMain.cm.toUser("PL|BMW|1", winningBid.getBidderName(), false);
                    CampaignMain.cm.toUser("You purchased the " + currList.getListedModelName() + " for " + CampaignMain.cm.moneyOrFluMessage(true, true, winningBidAmt) + ".", winningBid.getBidderName(), true);
                }
                if (new Boolean(CampaignMain.cm.getConfig("AllowPersonalPilotQueues")).booleanValue() && unitForSale.isSinglePilotUnit()) {
                    if (sellingActor.isHuman()) {
                        p = (SPlayer)sellingActor;
                        p.getPersonalPilotQueue().addPilot(unitForSale.getPilot(), unitForSale.getWeightclass());
                        CampaignMain.cm.toUser("PL|AP2PPQ|" + unitForSale.getType() + "|" + unitForSale.getWeightclass() + "|" + ((SPilot)unitForSale.getPilot()).toFileFormat("#", true), p.getName(), false);
                        p.getPersonalPilotQueue().checkQueueAndWarn(p.getName(), unitForSale.getType(), unitForSale.getWeightclass());
                    }
                    unitForSale.setPilot(new SPilot("Vacant", 99, 99));
                } else {
                    SHouse h;
                    if (sellingActor.isHuman()) {
                        p = (SPlayer)sellingActor;
                        p.getMyHouse().addDispossessedPilot(unitForSale, false);
                    } else {
                        h = (SHouse)sellingActor;
                        h.addDispossessedPilot(unitForSale, false);
                    }
                    if (buyingActor.isHuman()) {
                        p = (SPlayer)buyingActor;
                        unitForSale.setPilot(p.getMyHouse().getNewPilot(unitForSale.getType()));
                    } else {
                        h = (SHouse)buyingActor;
                        unitForSale.setPilot(h.getNewPilot(unitForSale.getType()));
                    }
                }
                sellingActor.removeUnit(unitForSale, false);
                buyingActor.addUnit(unitForSale, true, true);
                CampaignData.mwlog.bmLog(winningBid.getBidderName() + " bought a " + currList.getListedModelName() + " from " + currList.getSellerName() + " for " + winningBidAmt);
                listingsToRemove.add(currAuctionID);
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Error during Market Tick for unit " + currList.getListedModelName());
                CampaignData.mwlog.errLog(ex);
            }
        }
        lock.unlock();
        for (Integer idToRemove : listingsToRemove) {
            this.removeListing(idToRemove, true);
        }
        double rareChance = CampaignMain.cm.getRandomNumber(100001) / 1000;
        if (rareChance < CampaignMain.cm.getDoubleConfig("RareChance")) {
            int weightClass = CampaignMain.cm.getRandomNumber(4);
            String factionName = "Rare";
            String unitFluff = "Sold by mysterious figures";
            String unitFilename = BuildTable.getUnitFilename(factionName, Unit.getWeightClassDesc(weightClass), 0, "rare");
            Vector<SUnit> rareUnits = new Vector<SUnit>(1, 1);
            if (unitFilename.toLowerCase().trim().endsWith(".mul")) {
                rareUnits.addAll(SUnit.createMULUnits(unitFilename, unitFluff));
            } else {
                rareUnits.add(new SUnit(unitFluff, unitFilename, weightClass));
            }
            for (SUnit rareUnit : rareUnits) {
                SHouse sellingFaction = CampaignMain.cm.getHouseFromPartialString(CampaignMain.cm.getConfig("NewbieHouseName"), null);
                int priceForUnit = sellingFaction.getPriceForUnit(rareUnit.getWeightclass(), rareUnit.getType());
                int rareSalesTime = CampaignMain.cm.getIntegerConfig("RareMinSaleTime");
                this.addListing("Faction_" + sellingFaction.getName(), rareUnit, priceForUnit, rareSalesTime, true);
                sellingFaction.addUnit(rareUnit, true);
                rareUnit.setStatus(3);
            }
        }
    }

    public void sendCompleteMarketStatus(SPlayer p) {
        StringBuilder marketData = new StringBuilder();
        for (Integer currListID : this.currentAuctions.keySet()) {
            MarketListing currL = this.currentAuctions.get(currListID);
            marketData.append(currL.toString(currListID, p) + "$");
        }
        String result = marketData.toString();
        if (result.trim().length() > 0) {
            CampaignMain.cm.toUser("BM|AD|" + result, p.getName(), false);
        }
    }
}

