/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.market2;

import common.CampaignData;
import java.util.TreeMap;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.market2.MarketBid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MarketListing {
    private String sellerName;
    private int listedUnitID;
    private int minimumBid;
    private int saleDuration;
    private TreeMap<String, MarketBid> bidsReceived;
    String modelName;
    String fileName;

    public MarketListing(String sellname, SUnit unit, int minbid, int duration) {
        this.sellerName = sellname;
        this.listedUnitID = unit.getId();
        this.minimumBid = minbid;
        this.saleDuration = duration;
        this.bidsReceived = new TreeMap();
        this.modelName = unit.getModelName();
        this.fileName = unit.getUnitFilename();
    }

    public String toString(int id, SPlayer p) {
        StringBuilder toReturn = new StringBuilder();
        toReturn.append(id + "*");
        toReturn.append(this.getListedUnitID() + "*");
        if (this.getListedModelName().length() > 0) {
            toReturn.append(this.getListedModelName() + "*");
        } else {
            toReturn.append(" *");
        }
        toReturn.append(this.getListedFileName() + "*");
        toReturn.append(this.getSaleTicks() + "*");
        toReturn.append(this.getMinBid() + "*");
        if (p != null && this.getSellerName().equalsIgnoreCase(p.getName())) {
            toReturn.append(true);
        } else {
            toReturn.append(false);
        }
        toReturn.append("*");
        if (p != null) {
            toReturn.append(this.getBidForPlayer(p));
        } else {
            toReturn.append(0);
        }
        return toReturn.toString();
    }

    public void placeBid(String bidderName, int bidAmount) {
        try {
            String lowerName = bidderName.toLowerCase();
            MarketBid currBid = new MarketBid(bidAmount, System.currentTimeMillis());
            currBid.setBidderName(lowerName);
            if (bidAmount > 0) {
                this.bidsReceived.put(lowerName, currBid);
            } else if (bidAmount < 1 && this.bidsReceived.containsKey(lowerName)) {
                this.bidsReceived.remove(lowerName);
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public TreeMap<String, MarketBid> getAllBids() {
        return this.bidsReceived;
    }

    public int getBidForPlayer(SPlayer p) {
        for (MarketBid currBid : this.bidsReceived.values()) {
            if (!p.getName().equalsIgnoreCase(currBid.getBidderName())) continue;
            return currBid.getAmount();
        }
        return 0;
    }

    public int getMinBid() {
        return this.minimumBid;
    }

    public String getSellerName() {
        return this.sellerName;
    }

    public int getListedUnitID() {
        return this.listedUnitID;
    }

    public String getListedModelName() {
        return this.modelName;
    }

    public String getListedFileName() {
        return this.fileName;
    }

    public int getSaleTicks() {
        return this.saleDuration;
    }

    public void decreaseSaleTicks() {
        --this.saleDuration;
    }

    public void increaseSaleTicks() {
        ++this.saleDuration;
    }
}

