/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.market2;

import common.BMEquipment;
import common.CampaignData;
import common.Equipment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartsMarket {
    private HashMap<String, BMEquipment> equipmentList = new HashMap();
    private HashMap<String, BMEquipment> lastTickList = new HashMap();

    public PartsMarket() {
        this.loadParts();
    }

    public synchronized void tick() {
        for (String key : CampaignMain.cm.getBlackMarketEquipmentTable().keySet()) {
            BMEquipment eq = this.equipmentList.get(key);
            BMEquipment tickList = this.lastTickList.get(key);
            Equipment masterEq = CampaignMain.cm.getBlackMarketEquipmentTable().get(key);
            try {
                Thread.sleep(10L);
                if (masterEq.getMaxProduction() == 0) {
                    this.equipmentList.remove(key);
                    this.lastTickList.remove(key);
                    continue;
                }
                if ((eq == null || tickList == null) && masterEq.getMaxProduction() > 0) {
                    eq = new BMEquipment();
                    eq.setEquipmentInternalName(key);
                    eq.setAmount(Math.max(masterEq.getMinProduction(), CampaignMain.cm.getRandomNumber(masterEq.getMaxProduction()) + 1));
                    eq.setCost(Math.max(masterEq.getMinCost(), CampaignMain.cm.getR().nextDouble() * masterEq.getMaxCost()));
                    eq.setCostUp(false);
                    eq.getEquipmentName();
                    eq.getTech();
                    this.lastTickList.put(key, eq.clone());
                    this.equipmentList.put(key, eq);
                    continue;
                }
                if (eq.getAmount() < tickList.getAmount()) {
                    eq.setCostUp(true);
                    double costIncrease = (double)(masterEq.getMaxProduction() - eq.getAmount()) / (double)masterEq.getMaxProduction() + 1.0;
                    eq.setCost(Math.min(masterEq.getMaxCost(), Math.max(masterEq.getMinCost(), eq.getCost() * costIncrease)));
                    if (eq.getAmount() < masterEq.getMaxProduction()) {
                        int difference = masterEq.getMaxProduction() - eq.getAmount();
                        int amountIncrease = Math.min(1, Math.min(difference / 2, CampaignMain.cm.getRandomNumber(difference + 1)));
                        eq.setAmount(eq.getAmount() + amountIncrease);
                    }
                } else {
                    eq.setCostUp(false);
                    if (eq.getAmount() < masterEq.getMaxProduction()) {
                        int difference = masterEq.getMaxProduction() - eq.getAmount();
                        int amountIncrease = Math.min(1, Math.min(difference / 2, CampaignMain.cm.getRandomNumber(difference) + 1));
                        eq.setAmount(eq.getAmount() + amountIncrease);
                    }
                    double newCost = Math.max(masterEq.getMinCost(), Math.max(eq.getCost() * 0.9, CampaignMain.cm.getR().nextDouble() * eq.getCost()));
                    eq.setCost(newCost);
                }
            }
            catch (IllegalArgumentException iae) {
                eq.setCost(Math.abs(eq.getCost()));
                eq.setAmount(Math.abs(eq.getAmount()));
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
            eq.setAmount(Math.max(eq.getAmount(), masterEq.getMinProduction()));
            eq.getEquipmentName();
            eq.getTech();
            this.lastTickList.put(key, eq.clone());
            this.equipmentList.put(key, eq);
        }
        this.updatePartsBlackMarketAllPlayers();
        this.saveParts();
    }

    public synchronized void updatePartsBlackMarketAllPlayers() {
        String result = this.getPartsUpdateString();
        CampaignMain.cm.doSendToAllOnlinePlayers(result, false);
    }

    public String getPartsUpdateString() {
        StringBuilder result = new StringBuilder("PL|UPBM|");
        String delimiter = "#";
        try {
            for (String key : this.equipmentList.keySet()) {
                BMEquipment eq = this.equipmentList.get(key);
                result.append(eq.getEquipmentInternalName());
                result.append(delimiter);
                result.append(eq.getAmount());
                result.append(delimiter);
                result.append(eq.getCost());
                result.append(delimiter);
                result.append(eq.isCostUp());
                result.append(delimiter);
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
        return result.toString();
    }

    public synchronized void updatePartsBlackMarketPlayer(SPlayer player) {
        CampaignMain.cm.toUser(this.getPartsUpdateString(), player.getName(), false);
    }

    private void saveParts() {
        try {
            PrintStream ps = new PrintStream(new FileOutputStream("./data/partsblackmarket.dat"));
            for (String key : this.equipmentList.keySet()) {
                BMEquipment bme = this.equipmentList.get(key);
                if (CampaignMain.cm.getBlackMarketEquipmentTable().get(key) == null || CampaignMain.cm.getBlackMarketEquipmentTable().get(key).getMaxProduction() == 0) continue;
                ps.print(bme.getEquipmentInternalName());
                ps.print("#");
                ps.print(bme.getCost());
                ps.print("#");
                ps.print(bme.getAmount());
                ps.print("#");
            }
            ps.close();
        }
        catch (FileNotFoundException fe) {
            CampaignData.mwlog.errLog("partsblackmarket.dat not found");
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    private void loadParts() {
        try {
            File bmFile = new File("./data/partsblackmarket.dat");
            if (!bmFile.exists()) {
                return;
            }
            FileInputStream fis = new FileInputStream(bmFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            if (dis.ready()) {
                String line = dis.readLine();
                StringTokenizer data = new StringTokenizer(line, "#");
                while (data.hasMoreElements()) {
                    BMEquipment bme = new BMEquipment();
                    bme.setEquipmentInternalName(data.nextToken());
                    bme.setCost(Double.parseDouble(data.nextToken()));
                    bme.setAmount(Integer.parseInt(data.nextToken()));
                    bme.getEquipmentName();
                    bme.getTech();
                    this.equipmentList.put(bme.getEquipmentInternalName(), bme);
                    this.lastTickList.put(bme.getEquipmentInternalName(), bme.clone());
                }
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public HashMap<String, BMEquipment> getEquipmentList() {
        return this.equipmentList;
    }
}

