/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.market2;

import java.util.Iterator;
import java.util.TreeMap;
import server.campaign.CampaignMain;
import server.campaign.market2.IAuction;
import server.campaign.market2.MarketBid;
import server.campaign.market2.MarketListing;

public final class VickreyAuction
implements IAuction {
    public MarketBid getWinner(MarketListing listing) {
        MarketBid winningBid = null;
        TreeMap<MarketBid, String> orderedBids = new TreeMap<MarketBid, String>();
        TreeMap<String, MarketBid> placedBids = listing.getAllBids();
        for (String bidderName : placedBids.keySet()) {
            orderedBids.put(placedBids.get(bidderName), bidderName);
        }
        Iterator i = orderedBids.keySet().iterator();
        while (i.hasNext()) {
            MarketBid currBid = (MarketBid)i.next();
            Comparable<Object> potentialWinner = CampaignMain.cm.getPlayer(currBid.getBidderName());
            if (potentialWinner == null) {
                potentialWinner = CampaignMain.cm.getHouseFromPartialString(currBid.getBidderName(), null);
            }
            if (potentialWinner == null) continue;
            if (potentialWinner.getMoney() < currBid.getAmount()) {
                if (!potentialWinner.isHuman()) continue;
                CampaignMain.cm.toUser("The " + listing.getListedModelName() + " from the BM could have been yours! Unfortunately, you don't have the " + CampaignMain.cm.moneyOrFluMessage(true, true, currBid.getAmount()) + " you " + "offered.", currBid.getBidderName(), true);
                continue;
            }
            winningBid = currBid;
            break;
        }
        if (winningBid == null) {
            return null;
        }
        if (i.hasNext()) {
            Comparable<Object> potentialWinner;
            MarketBid nextBid = (MarketBid)i.next();
            int nextBidAmount = nextBid.getAmount();
            if (nextBidAmount < winningBid.getAmount()) {
                winningBid.setAmount(nextBidAmount + 1);
            }
            if ((potentialWinner = CampaignMain.cm.getPlayer(nextBid.getBidderName())) == null) {
                potentialWinner = CampaignMain.cm.getHouseFromPartialString(nextBid.getBidderName(), null);
            }
            if (potentialWinner != null && potentialWinner.isHuman()) {
                CampaignMain.cm.toUser("You didn't get the  " + listing.getListedModelName() + " for " + CampaignMain.cm.moneyOrFluMessage(true, true, nextBidAmount) + ". Yours was the " + "second place offer. The winner paid " + CampaignMain.cm.moneyOrFluMessage(true, true, winningBid.getAmount()) + ".", nextBid.getBidderName(), true);
            }
        } else {
            winningBid.setAmount(listing.getMinBid());
        }
        while (i.hasNext()) {
            MarketBid losingBid = (MarketBid)i.next();
            Comparable<Object> loser = CampaignMain.cm.getPlayer(losingBid.getBidderName());
            if (loser == null) {
                loser = CampaignMain.cm.getHouseFromPartialString(losingBid.getBidderName(), null);
            }
            if (loser == null || !loser.isHuman()) continue;
            CampaignMain.cm.toUser("You didn't get the  " + listing.getListedModelName() + " for " + CampaignMain.cm.moneyOrFluMessage(true, true, losingBid.getAmount()) + ". The " + "winner paid " + CampaignMain.cm.moneyOrFluMessage(true, true, winningBid.getAmount()) + ".", losingBid.getBidderName(), true);
        }
        return winningBid;
    }
}

