/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.mercenaries;

import common.CampaignData;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;

public class ContractInfo
implements Serializable {
    private static final long serialVersionUID = 3985382192530405331L;
    private int _contractDuration;
    private int _earnedAmount;
    private int _payment;
    private int _type = 0;
    private String _contractingHouse;
    private String _playerName;
    private String _offeringPlayer;
    private int DBId = 0;
    public static final int CONTRACT_EXP = 0;
    public static final int CONTRACT_LAND = 1;
    public static final int CONTRACT_UNITS = 2;
    public static final int CONTRACT_COMPONENTS = 3;
    public static final int CONTRACT_DELAY = 4;

    public ContractInfo(int duration, int payment, SHouse contractHouse, String name, int type) {
        this._contractDuration = duration;
        this._earnedAmount = 0;
        this._payment = payment;
        this._contractingHouse = contractHouse.getName();
        this._playerName = name;
        this._type = type;
    }

    public int getContractDuration() {
        return this._contractDuration;
    }

    public int getEarnedAmount() {
        return this._earnedAmount;
    }

    public void setEarnedAmount(int amount) {
        this._earnedAmount = amount;
    }

    public SHouse getEmployingHouse() {
        return CampaignMain.cm.getHouseFromPartialString(this._contractingHouse, null);
    }

    public String getPlayerName() {
        return this._playerName;
    }

    public int getPayment() {
        return this._payment;
    }

    public int getType() {
        return this._type;
    }

    public SPlayer getOfferingPlayer() {
        return CampaignMain.cm.getPlayer(this._offeringPlayer);
    }

    public String getOfferingPlayerName() {
        return this._offeringPlayer;
    }

    public void setOfferingPlayer(SPlayer p) {
        this._offeringPlayer = p.getName().toLowerCase();
    }

    public boolean isLegal() {
        if (CampaignMain.cm.getHouseFromPartialString(this._contractingHouse) == null) {
            return false;
        }
        if (CampaignMain.cm.getPlayer(this._offeringPlayer) == null) {
            return false;
        }
        return CampaignMain.cm.getPlayer(this._playerName) != null;
    }

    public String toString() {
        String result = "CON$";
        result = result + this._contractDuration;
        result = result + "$";
        result = result + this._earnedAmount;
        result = result + "$";
        result = result + this._payment;
        result = result + "$";
        result = result + this._contractingHouse;
        result = result + "$";
        result = result + this._playerName.toLowerCase();
        result = result + "$";
        result = result + this._offeringPlayer;
        result = result + "$";
        result = result + this._type;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toDB() {
        if (this.getDBId() == 0) {
            PreparedStatement ps = CampaignMain.cm.MySQL.getPreparedStatement("INSERT INTO merc_contract_info SET contractDuration = ?, contractEarnedAmount = ?, ContractPayment = ?, contractHouse = ?, contractPlayer = ?, contractOfferingPlayer = ?, contractType = ?", 1);
            ResultSet rs = null;
            try {
                ps.setInt(1, this._contractDuration);
                ps.setInt(2, this._earnedAmount);
                ps.setInt(3, this._payment);
                ps.setString(4, this._contractingHouse);
                ps.setString(5, this._playerName);
                ps.setString(6, this._offeringPlayer);
                ps.setInt(7, this._type);
                ps.executeUpdate();
                rs = ps.getGeneratedKeys();
                if (rs.next()) {
                    this.setDBId(rs.getInt(1));
                }
                CampaignData.mwlog.dbLog("Error inserting contract in ContractInfo.toDB():  No key generated");
            }
            catch (SQLException e) {
                CampaignData.mwlog.dbLog("SQLException in ContractInfo.toDB(): " + e.getMessage());
                CampaignData.mwlog.dbLog(e);
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e) {
                        CampaignData.mwlog.dbLog("SQLException in ContractInfo.toDB(): " + e.getMessage());
                        CampaignData.mwlog.dbLog(e);
                    }
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        CampaignData.mwlog.dbLog("SQLException in ContractInfo.toDB(): " + e.getMessage());
                        CampaignData.mwlog.dbLog(e);
                    }
                }
            }
        } else {
            PreparedStatement ps = CampaignMain.cm.MySQL.getPreparedStatement("UPDATE merc_contract_info SET contractDuration = ?, contractEarnedAmount = ?, ContractPayment = ?, contractHouse = ?, contractPlayer = ?, contractOfferingPlayer = ?, contractType = ? WHERE contractID = ?");
            try {
                ps.setInt(1, this._contractDuration);
                ps.setInt(2, this._earnedAmount);
                ps.setInt(3, this._payment);
                ps.setString(4, this._contractingHouse);
                ps.setString(5, this._playerName);
                ps.setString(6, this._offeringPlayer);
                ps.setInt(7, this._type);
                ps.setInt(8, this.getDBId());
                ps.executeUpdate();
            }
            catch (SQLException e) {
                CampaignData.mwlog.dbLog("SQLException in ContractInfo.toDB(): " + e.getMessage());
                CampaignData.mwlog.dbLog(e);
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e) {
                        CampaignData.mwlog.dbLog("SQLException in ContractInfo.toDB(): " + e.getMessage());
                        CampaignData.mwlog.dbLog(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromDB(int dbid) {
        Statement stmt = CampaignMain.cm.MySQL.getStatement();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery("SELECT * from merc_contract_info WHERE contractID = " + dbid);
            if (rs.next()) {
                this._contractDuration = rs.getInt("contractDuration");
                this._earnedAmount = rs.getInt("contractEarnedAmount");
                this._payment = rs.getInt("contractPayment");
                this._contractingHouse = rs.getString("contractHouse");
                this._playerName = rs.getString("contractPlayer");
                this._offeringPlayer = rs.getString("contractOfferingPlayer");
                this._type = rs.getInt("contractType");
                this.setDBId(dbid);
            }
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in ContractInfo.fromDB(): " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                CampaignData.mwlog.dbLog("SQLException in ContractInfo.fromDB(): " + e.getMessage());
                CampaignData.mwlog.dbLog(e);
            }
        }
    }

    public void fromString(String s) {
        s = s.substring(4);
        StringTokenizer ST = new StringTokenizer(s, "$");
        this._contractDuration = Integer.parseInt(ST.nextToken());
        this._earnedAmount = Integer.parseInt((String)ST.nextElement());
        this._payment = Integer.parseInt((String)ST.nextElement());
        this._contractingHouse = ST.nextToken();
        this._playerName = ST.nextToken();
        this._offeringPlayer = ST.nextToken();
        if (ST.hasMoreElements()) {
            this._type = Integer.parseInt(ST.nextToken());
        }
    }

    public ContractInfo() {
    }

    public String getInfo(SPlayer player) {
        StringBuilder info = new StringBuilder("Contract Status: ");
        int duration = this.getContractDuration();
        int performedXP = this.getEarnedAmount();
        info.append(performedXP + " of " + duration + " " + ContractInfo.getContractName(this.getType()) + " performed.<br>");
        return info.toString();
    }

    public static int getContractType(String type) {
        if (type.equalsIgnoreCase("land")) {
            return 1;
        }
        if (type.equalsIgnoreCase("units")) {
            return 2;
        }
        if (type.equalsIgnoreCase("components")) {
            return 3;
        }
        if (type.equalsIgnoreCase("delay")) {
            return 4;
        }
        return 0;
    }

    public static String getContractName(int type) {
        String contract = "Exp";
        switch (type) {
            case 1: {
                contract = "Land";
                break;
            }
            case 2: {
                contract = "Units";
                break;
            }
            case 3: {
                contract = "Components";
                break;
            }
            case 4: {
                contract = "Delay";
                break;
            }
            default: {
                contract = "Exp";
            }
        }
        return contract;
    }

    public int getDBId() {
        return this.DBId;
    }

    public void setDBId(int dbID) {
        this.DBId = dbID;
    }
}

