/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.mercenaries;

import java.util.Enumeration;
import java.util.Hashtable;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.mercenaries.ContractInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MercHouse
extends SHouse {
    private static final long serialVersionUID = 5440419107794020517L;
    private Hashtable<String, ContractInfo> OutstandingContracts = new Hashtable();

    public MercHouse(int id, String name, String HouseColor, int BaseGunner, int BasePilot, String abbreviation) {
        super(id, name, HouseColor, BaseGunner, BasePilot, abbreviation);
    }

    public MercHouse(int id) {
        super(id);
    }

    public MercHouse() {
    }

    @Override
    public int getDistanceTo(SPlanet p, SPlayer player) {
        if (this.getHouseFightingFor(player).isMercHouse()) {
            return 0x7FFFFFFD;
        }
        return this.getHouseFightingFor(player).getDistanceTo(p, player);
    }

    @Override
    public boolean isMercHouse() {
        return true;
    }

    @Override
    public SHouse getHouseFightingFor(SPlayer player) {
        ContractInfo playerContract = this.getOutstandingContracts().get(player.getName().toLowerCase());
        if (playerContract != null) {
            return playerContract.getEmployingHouse();
        }
        return this;
    }

    public void setContract(ContractInfo cToAdd, SPlayer player) {
        this.getOutstandingContracts().put(player.getName().toLowerCase(), cToAdd);
        this.setOutstandingContracts(this.getOutstandingContracts());
    }

    public boolean endContract(SPlayer player) {
        boolean terminated = false;
        if (this.getOutstandingContracts().containsKey(player.getName().toLowerCase())) {
            this.getOutstandingContracts().remove(player.getName().toLowerCase());
            terminated = true;
        }
        return terminated;
    }

    public ContractInfo getContractInfo(SPlayer player) {
        ContractInfo currentContract = null;
        currentContract = this.getOutstandingContracts().get(player.getName().toLowerCase());
        return currentContract;
    }

    @Override
    public int getBaysProvided() {
        int mercBays = CampaignMain.cm.getIntegerConfig("MercHouseBays");
        return mercBays;
    }

    public String payWelfare(SPlayer p) {
        String s = "";
        s = p.getMoney() < 30 ? "You're running low on funds. It may be time to secure a loan." : "";
        return s;
    }

    @Override
    public String toString() {
        ContractInfo ci;
        StringBuilder result = new StringBuilder();
        result.append("[M]");
        result.append(super.toString());
        Enumeration<ContractInfo> e = this.getOutstandingContracts().elements();
        while (e.hasMoreElements()) {
            ci = e.nextElement();
            if (ci.isLegal()) continue;
            this.getOutstandingContracts().remove(ci.getOfferingPlayerName().toLowerCase());
        }
        result.append(this.getOutstandingContracts().size());
        result.append("|");
        e = this.getOutstandingContracts().elements();
        while (e.hasMoreElements()) {
            ci = e.nextElement();
            result.append(ci.toString());
            result.append("|");
        }
        return result.toString();
    }

    @Override
    public void toDB() {
        super.toDB();
        Enumeration<ContractInfo> e = this.getOutstandingContracts().elements();
        while (e.hasMoreElements()) {
            ContractInfo ci = e.nextElement();
            if (!ci.isLegal()) {
                this.getOutstandingContracts().remove(ci.getOfferingPlayerName().toLowerCase());
            }
            ci.toDB();
        }
    }

    public Hashtable<String, ContractInfo> getOutstandingContracts() {
        return this.OutstandingContracts;
    }

    public void setOutstandingContracts(Hashtable<String, ContractInfo> h) {
        this.OutstandingContracts = h;
    }

    public boolean canConquerPlanets() {
        return false;
    }
}

