/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.operations;

import java.util.Collections;
import java.util.Vector;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.operations.ShortOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongOperation
implements Comparable<LongOperation> {
    public static int STATUS_IDLE = 0;
    public static int STATUS_OPINPROGRESS = 1;
    public static int STATUS_FINISHED = 2;
    private SPlanet targetWorld;
    private Vector<Integer> shortIDs;
    private SHouse attackingHouse;
    private SHouse defendingHouse;
    private int longID;
    private int gamesPlayed;
    private int gamesWon;
    private int duration;
    private int currentStatus;
    private int showsToClear;
    private Vector<ShortOperation> activeShorts;
    private String opName;

    public LongOperation(String opName, SPlanet target, int id, SHouse attacker, SHouse defender, int duration) {
        this.opName = opName;
        this.targetWorld = target;
        this.longID = id;
        this.attackingHouse = attacker;
        this.defendingHouse = defender;
        this.duration = duration;
        this.gamesPlayed = 0;
        this.gamesWon = 0;
        this.currentStatus = STATUS_IDLE;
    }

    public int getStatus() {
        return this.currentStatus;
    }

    public void setStatus(int i) {
        this.currentStatus = i;
    }

    public SPlanet getTargetWorld() {
        return this.targetWorld;
    }

    public int getID() {
        return this.longID;
    }

    public String getName() {
        return this.opName;
    }

    public Vector<ShortOperation> getActiveShortops() {
        if (this.getStatus() == STATUS_OPINPROGRESS) {
            return this.activeShorts;
        }
        return null;
    }

    public void addShortOp(ShortOperation o) {
        this.activeShorts.add(o);
        Collections.sort(this.activeShorts);
    }

    public String getIdleInfo() {
        String resultString = "";
        resultString = resultString + "#" + this.getID() + " ";
        resultString = resultString + this.attackingHouse.getColoredNameAsLink() + " is ";
        resultString = resultString + " has begun a " + this.opName + " on " + this.targetWorld.getNameAsColoredLink() + ". ";
        resultString = resultString + this.defendingHouse.getNameAsLink() + " forces are mobilizing in defense.";
        return resultString;
    }

    public SHouse getAttackingHouse() {
        return this.attackingHouse;
    }

    public SHouse getDefendingHouse() {
        return this.defendingHouse;
    }

    public String getInProgressInfo(boolean complete) {
        return "";
    }

    public String getFinishedInfo(boolean complete) {
        return "";
    }

    @Override
    public int compareTo(LongOperation o) {
        try {
            LongOperation compOp = o;
            if (compOp.getID() > this.getID()) {
                return 1;
            }
            if (compOp.getID() == this.getID()) {
                return 0;
            }
            return -1;
        }
        catch (Exception ex) {
            return 0;
        }
    }
}

