/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.operations;

import common.CampaignData;
import common.DefaultOperation;
import java.util.Properties;
import java.util.TreeMap;
import server.campaign.operations.ModifyingOperation;

public class Operation {
    public static int TYPE_SHORTONLY = 0;
    public static int TYPE_SHORTANDLONG = 1;
    public static int MODS_NOTACCEPTED = 0;
    public static int MODS_ACCEPTED = 1;
    private int type_indicator;
    private int mods_indicator;
    TreeMap<String, ModifyingOperation> modifyingOperations;
    Properties opValues;
    DefaultOperation opsDefaults;
    String opName;

    public Operation(String opName, DefaultOperation defaults, Properties params) {
        this.opName = opName;
        this.opsDefaults = defaults;
        this.type_indicator = TYPE_SHORTONLY;
        this.mods_indicator = MODS_NOTACCEPTED;
        this.modifyingOperations = new TreeMap();
        this.opValues = params;
    }

    public String getValue(String valToGet) {
        String toReturn = (String)this.opValues.get(valToGet);
        if (toReturn == null) {
            toReturn = this.opsDefaults.getDefault(valToGet);
        }
        if (toReturn == null) {
            CampaignData.mwlog.errLog("Failed getting value \"" + valToGet + "\" from " + this.getName() + " and DefaultOp. Returning null.");
            try {
                throw new Exception();
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
        }
        return toReturn;
    }

    public boolean getBooleanValue(String valToGet) {
        try {
            return Boolean.parseBoolean(this.getValue(valToGet));
        }
        catch (Exception ex) {
            return false;
        }
    }

    public int getIntValue(String valToGet) {
        try {
            return Integer.parseInt(this.getValue(valToGet));
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public double getDoubleValue(String valToGet) {
        try {
            return Double.parseDouble(this.getValue(valToGet));
        }
        catch (Exception ex) {
            return -1.0;
        }
    }

    public float getFloatValue(String valToGet) {
        try {
            return Float.parseFloat(this.getValue(valToGet));
        }
        catch (Exception ex) {
            return -1.0f;
        }
    }

    public void addModifyingOperation(ModifyingOperation m) {
        this.modifyingOperations.put(m.getName(), m);
        this.mods_indicator = MODS_ACCEPTED;
    }

    public int getTypeIndicator() {
        return this.type_indicator;
    }

    public void setTypeIndicator(int i) {
        this.type_indicator = i;
    }

    public int getModsIndicator() {
        return this.mods_indicator;
    }

    public void setModsIndicator(int i) {
        this.mods_indicator = i;
    }

    public String getName() {
        return this.opName;
    }
}

