/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.operations;

import common.CampaignData;
import java.util.StringTokenizer;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationEntity {
    private String ownerName;
    private int CTint = 1;
    private int HDint = 1;
    private int LLint = 1;
    private int RLint = 1;
    private int RAint = 1;
    private int LAint = 1;
    private int gyrohits = 0;
    private int pilothits = 0;
    private int offBoardRange = 0;
    private int cockpitType = 0;
    private boolean isSalvage = false;
    private boolean pilotUnconscious = false;
    private boolean isImmobile = false;
    private boolean crewDead = false;
    private int MMUnitType;
    private int ID;
    private int RemovalReason;
    private String unitFileName = "";
    private String unitDamage = "";
    private Vector<Integer> kills = new Vector(1, 1);

    public OperationEntity(String s) {
        try {
            SUnit currUnit;
            SPlayer player;
            StringTokenizer ST = new StringTokenizer(s, "*");
            this.ID = Integer.parseInt(ST.nextToken());
            StringTokenizer nameT = new StringTokenizer(ST.nextToken(), "~");
            String pname = "";
            while (nameT.hasMoreElements()) {
                pname = nameT.nextToken().trim();
            }
            this.ownerName = pname;
            this.pilothits = Integer.parseInt(ST.nextToken());
            this.RemovalReason = Integer.parseInt(ST.nextToken());
            this.MMUnitType = Integer.parseInt(ST.nextToken());
            StringTokenizer STR = new StringTokenizer(ST.nextToken(), "~");
            while (STR.hasMoreElements()) {
                String kill = STR.nextToken();
                if (kill.trim().equals("")) continue;
                Integer killid = new Integer(kill);
                this.kills.add(killid);
            }
            if (this.MMUnitType == 0 || this.MMUnitType == 6) {
                this.pilotUnconscious = Boolean.parseBoolean(ST.nextToken());
                this.CTint = Integer.parseInt(ST.nextToken());
                this.HDint = Integer.parseInt(ST.nextToken());
                this.LLint = Integer.parseInt(ST.nextToken());
                this.RLint = Integer.parseInt(ST.nextToken());
                this.LAint = Integer.parseInt(ST.nextToken());
                this.RAint = Integer.parseInt(ST.nextToken());
                this.gyrohits = Integer.parseInt(ST.nextToken());
                this.cockpitType = Integer.parseInt(ST.nextToken());
                if (CampaignMain.cm.isUsingAdvanceRepair() && ST.hasMoreElements()) {
                    this.unitDamage = ST.nextToken();
                }
                this.unitFileName = ST.nextToken();
                player = CampaignMain.cm.getPlayer(this.ownerName);
                if (player != null && (currUnit = player.getUnit(this.ID)) != null) {
                    currUnit.setLastCombatPilot(currUnit.getPilot().getPilotId());
                }
            } else if (this.MMUnitType == 1) {
                this.isSalvage = Boolean.parseBoolean(ST.nextToken());
                this.isImmobile = Boolean.parseBoolean(ST.nextToken());
                this.crewDead = Boolean.parseBoolean(ST.nextToken());
                player = CampaignMain.cm.getPlayer(this.ownerName);
                if (CampaignMain.cm.isUsingAdvanceRepair() && ST.hasMoreElements()) {
                    this.unitDamage = ST.nextToken();
                }
                if (player != null && this.ID != -1 && (currUnit = player.getUnit(this.ID)) != null && currUnit.getPilot() != null) {
                    currUnit.setLastCombatPilot(currUnit.getPilot().getPilotId());
                }
                this.unitFileName = ST.nextToken();
            } else if (this.MMUnitType == 5) {
                this.isSalvage = Boolean.parseBoolean(ST.nextToken());
                this.isImmobile = Boolean.parseBoolean(ST.nextToken());
                this.crewDead = Boolean.parseBoolean(ST.nextToken());
                player = CampaignMain.cm.getPlayer(this.ownerName);
                if (player != null && this.ID != -1 && (currUnit = player.getUnit(this.ID)) != null && currUnit.getPilot() != null) {
                    currUnit.setLastCombatPilot(currUnit.getPilot().getPilotId());
                }
                this.unitFileName = ST.nextToken();
            }
            if (ST.hasMoreElements()) {
                this.setOffBoardRange(Integer.parseInt(ST.nextToken()));
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Error while parsing the following String: " + s);
            CampaignData.mwlog.errLog(ex);
        }
    }

    public OperationEntity(String playername, int unitID, int removalReason, int ctIS, int headIS, boolean repairable) {
        this.ID = unitID;
        this.RemovalReason = removalReason;
        this.CTint = ctIS;
        this.HDint = headIS;
        this.isSalvage = repairable;
        this.ownerName = playername;
        try {
            this.MMUnitType = CampaignMain.cm.getPlayer(this.ownerName).getUnit(this.ID).getType();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public Vector<Integer> getKills() {
        return this.kills;
    }

    public int getCTint() {
        return this.CTint;
    }

    public void setCTint(int newInternals) {
        this.CTint = newInternals;
    }

    public int getHDint() {
        return this.HDint;
    }

    public int getPilothits() {
        return this.pilothits;
    }

    public void setPilothits(int hits) {
        this.pilothits = hits;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public SPlayer getOwner() {
        return CampaignMain.cm.getPlayer(this.ownerName);
    }

    public int getType() {
        return this.MMUnitType;
    }

    public int getID() {
        return this.ID;
    }

    public boolean isSalvagable() {
        if (this.getRemovalReason() == 1024) {
            return false;
        }
        if (CampaignMain.cm.getBooleanConfig("UsePartsRepair") && (this.MMUnitType == 0 || this.MMUnitType == 6 || this.MMUnitType == 1)) {
            return true;
        }
        if (this.MMUnitType == 0 || this.MMUnitType == 6) {
            return this.getCTint() > 0;
        }
        if (this.MMUnitType == 1) {
            return this.isSalvage;
        }
        return false;
    }

    public int getRemovalReason() {
        return this.RemovalReason;
    }

    public void setRemovalReason(int reason) {
        this.RemovalReason = reason;
    }

    public boolean isLiving() {
        if (this.getCTint() <= 0) {
            return false;
        }
        switch (this.getRemovalReason()) {
            case 512: 
            case 528: 
            case 1024: {
                return false;
            }
            case 256: 
            case 272: {
                return true;
            }
        }
        return this.canStand();
    }

    public boolean canStand() {
        if (CampaignMain.cm.getBooleanConfig("ForceSalvage")) {
            if (this.MMUnitType == 0) {
                if (this.getLLint() <= 0 || this.getRLint() <= 0 || this.getGyrohits() >= 2) {
                    return false;
                }
            } else if (this.MMUnitType == 6) {
                int missingLegsCount = 0;
                if (this.getLLint() <= 0) {
                    ++missingLegsCount;
                }
                if (this.getRLint() <= 0) {
                    ++missingLegsCount;
                }
                if (this.getRAint() <= 0) {
                    ++missingLegsCount;
                }
                if (this.getLAint() <= 0) {
                    ++missingLegsCount;
                }
                if (missingLegsCount >= 2 || this.getGyrohits() >= 2) {
                    return false;
                }
            } else if (this.MMUnitType == 1) {
                return !this.isImmobile;
            }
        }
        return true;
    }

    public boolean isSalvage() {
        return this.isSalvage;
    }

    public boolean isCrewDead() {
        return this.crewDead;
    }

    public void setSalvage(boolean newSalvage) {
        this.isSalvage = newSalvage;
    }

    public int getLLint() {
        return this.LLint;
    }

    public boolean isPilotUnconscious() {
        return this.pilotUnconscious;
    }

    public int getRLint() {
        return this.RLint;
    }

    public int getGyrohits() {
        return this.gyrohits;
    }

    public int getLAint() {
        return this.LAint;
    }

    public int getRAint() {
        return this.RAint;
    }

    public boolean isOffBoard() {
        return this.offBoardRange > 0;
    }

    public void setOffBoardRange(int range) {
        this.offBoardRange = range;
    }

    public int getOffBoardRange() {
        return this.offBoardRange;
    }

    public int getCockpitType() {
        return this.cockpitType;
    }

    public String getUnitDamage() {
        return this.unitDamage;
    }

    public String getUnitFileName() {
        return this.unitFileName;
    }
}

